<?php
	/*
		NNRPlib - A NNRP library
		Copyright (C) 1998 SJM Steffann & Computel Standby BV
		
		This library is free software; you can redistribute it and/or
		modify it under the terms of the GNU Library General Public
		License as published by the Free Software Foundation; either
		version 2 of the License, or (at your option) any later version.

		This library is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
		Library General Public License for more details.

		You should have received a copy of the GNU Library General Public
		License along with this library; if not, write to the Free
		Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	*/

	function nnrp_open($server) {
		global $NNRP_GLOBAL_STATUS;
	
		$nnrp = fsockopen($server, 119);
		if ($nnrp < 0) return -1;
	
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 2) <> "20") return -1;

		fputs($nnrp, "MODE READER\r\n");
		
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 2) <> "20") return -1;
		
		if (substr($line, 2, 1) == "0") {
			$NNRP_GLOBAL_STATUS[$nnrp]["POST"] = 1;
		} else {
			$NNRP_GLOBAL_STATUS[$nnrp]["POST"] = 0;
		}
		
		$NNRP_GLOBAL_STATUS["group"] = "";
		$NNRP_GLOBAL_STATUS["count"] = 0;
		$NNRP_GLOBAL_STATUS["first"] = 0;
		$NNRP_GLOBAL_STATUS["last"] = 0;
		
		return $nnrp;
	}

	function nnrp_authinfo($nnrp, $user, $pass) {
		global $NNRP_GLOBAL_STATUS;
	
		fputs($nnrp, "AUTHINFO USER $user\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "381") return -1;

		fputs($nnrp, "AUTHINFO PASS $pass\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "281") return -1;
		
		return 0;
	}
	
	function nnrp_list($nnrp) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "LIST\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "215") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$tok = strtok($line, " ");
			$groups[$i] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["last"] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["first"] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["post"] = (($tok == "y") ? true : false);
			$i++;
		}
		$groups["count"] = $i;
		return $groups;
	}
	
	function nnrp_newgroups($nnrp, $timestamp, $distr="") {
		global $NNRP_GLOBAL_STATUS;
		
		if (strlen($distr) > 0) {
			$distr = "<".$distr.">";
		}

		$datestring = gmdate("ymd His", $timestamp);

		fputs($nnrp, "NEWGROUPS $datestring GMT $distr\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "231") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$tok = strtok($line, " ");
			$groups[$i] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["last"] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["first"] = $tok;
			$tok = strtok($line, " ");
			$groups[$i]["post"] = (($tok == "y") ? true : false);
			$i++;
		}
		$groups["count"] = $i;
		return $groups;
	}
	
	function nnrp_newnews($nnrp, $newsgroups, $timestamp, $distr="") {
		global $NNRP_GLOBAL_STATUS;
		
		if (strlen($distr) > 0) {
			$distr = "<".$distr.">";
		}

		$datestring = gmdate("ymd His", $timestamp);

		fputs($nnrp, "NEWNEWS $newsgroups $datestring GMT $distr\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "230") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$messages[$i] = $line;
			$i++;
		}
		$messages["count"] = $i;
		return $messages;
	}
	
	function nnrp_post($nnrp, $newsgroups, $from, $subject, $message, $reply_to="", $organization="", $follow_up="", $references="") {
		global $NNRP_GLOBAL_STATUS;
		global $SERVER_NAME;
		
		fputs($nnrp, "POST\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "340") return -1;
		
		fputs($nnrp, "From: $from\r\n");
		if (strlen($reply_to) > 0) {
			fputs($nnrp, "Reply-To: $reply_to\r\n");
		}
		fputs($nnrp, "Sender: gateway@$SERVER_NAME\r\n");
		fputs($nnrp, "Newsgroups: $newsgroups\r\n");
		fputs($nnrp, "Subject: $subject\r\n");
		if (strlen($organization) == 0) {
			$organization = "NNRP Gateway at http://$SERVER_NAME/\r\n";
		}
		fputs($nnrp, "Organization: $organization\r\n");
		if (strlen($follow_up) > 0) {
			fputs($nnrp, "Followup-To: $follow_up\r\n");
		}
		if (strlen($references) > 0) {
			fputs($nnrp, "References: $references\r\n");
		}
		fputs($nnrp, "\r\n");

		$newmessage = ereg_replace("([^\r\n])$", "\\1\r\n", $message);
		$newmessage = ereg_replace("\n\r","\r\n",$newmessage);
		$newmessage = ereg_replace("([^\r])\n","\\1\r\n", $newmessage);
		$newmessage = ereg_replace("\r([^\n])","\r\n\\1", $newmessage);
		$newmessage = ereg_replace("\r$","\r\n", $newmessage);
		$newmessage = ereg_replace("^\n","\r\n", $newmessage);

		$newmessage = ereg_replace("\r\n\.([^\.])", "\r\n..\\1", $newmessage);
		$newmessage = ereg_replace("\r\n\.$", "\r\n..", $newmessage);

		fputs($nnrp, "$newmessage");
		fputs($nnrp, ".\r\n");

		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "240") return -1;
		
		return 0;
	}
	
	function nnrp_listgroup($nnrp, $group) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "LISTGROUP $group\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "211") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$tok = strtok($line, " ");
			$articles[$i] = intval($tok);
			$i++;
		}
		$articles["count"] = $i;
		return $articles;
	}
	
	function nnrp_group($nnrp, $group) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "GROUP $group\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "211") return -1;
		
		while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);

		$tok = strtok($line, " ");		/* $tok = 211 */
		$tok = strtok(" ");				/* $tok = nr */
		$NNRP_GLOBAL_STATUS["count"] = $info["count"] = intval($tok);
		$tok = strtok(" ");				/* $tok = low */
		$NNRP_GLOBAL_STATUS["first"] = $info["first"] = intval($tok);
		$tok = strtok(" ");				/* $tok = high */
		$NNRP_GLOBAL_STATUS["last"] = $info["last"] = intval($tok);
		
		$NNRP_GLOBAL_STATUS["group"] = $group;
		
		return $info;
	}
	
	function nnrp_article($nnrp, $article) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "ARTICLE $article\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "220") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$data[$i] = $line;
			$i++;
		}
		$data["count"] = $i;

		return $data;
	}

	function nnrp_overviewformat($nnrp, $full=false) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "LIST overview.fmt\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "215") return -1;

		$i = 0;
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			if ($full == false) {
				$headers[$i] = strtok($line, ":");
			} else {
				$headers[$i]["name"] = strtok($line, ":");
				$headers[$i]["full"] = (strtolower(strtok("\n")) == "full");
			}
			$i++;
		}
		$headers["count"] = $i;
		
		return $headers;
	}
	
	function nnrp_overview($nnrp, $first="none", $last="none") {
		global $NNRP_GLOBAL_STATUS;
		
		if ($first == "none") {
			$first = $NNRP_GLOBAL_STATUS["first"];
			$last  = $NNRP_GLOBAL_STATUS["last"];
		} else {
			if ($last == "none") {
				$last  = $first;
			}
		}

		if (($headers = nnrp_overviewformat($nnrp, true)) == -1) {
			return -1;
		}

		fputs($nnrp, "XOVER ".$first."-".$last."\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "224") return -1;

		$i = 0;
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$art = intval(strtok($line, "\t"));
			$j = 0;
			while ($j < $headers["count"]) {
				if ($headers[$j]["full"]) {
					$overview[$art][$headers[$j]["name"]] = substr(strtok("\t"), strlen($headers[$j]["name"])+2, 1024);
				} else {
					$overview[$art][$headers[$j]["name"]] = strtok("\t");
				}
				$j++;
			}
			$i++;
		}
		$overview["count"] = $i;

		return $overview;
	}
	
	function nnrp_head($nnrp, $article) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "HEAD $article\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "221") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$data[$i] = $line;
			$i++;
		}
		$data["count"] = $i;

		return $data;
	}

	function nnrp_body($nnrp, $article) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "BODY $article\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "222") return -1;
	
		$i = 0;	
		while (substr($line = fgets($nnrp, 1024), 0, 1) <> ".") {
			while ((strlen($line) > 0) && (($line[strlen($line)-1] == "\n") || ($line[strlen($line)-1] == "\r"))) $line = substr($line, 0, strlen($line)-1);
			$data[$i] = $line;
			$i++;
		}
		$data["count"] = $i;

		return $data;
	}
	
	function nnrp_close($nnrp) {
		global $NNRP_GLOBAL_STATUS;

		fputs($nnrp, "QUIT\r\n");
		$line = fgets($nnrp, 1024);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"] = substr($line, 0, 3);
		$NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"] = substr($line, 4, 1024);
		if (substr($line, 0, 3) <> "205") return -1;

		$NNRP_GLOBAL_STATUS["group"] = "";
		$NNRP_GLOBAL_STATUS["count"] = 0;
		$NNRP_GLOBAL_STATUS["first"] = 0;
		$NNRP_GLOBAL_STATUS["last"] = 0;

		fclose($nnrp);
		return 0;
	}
	
	function nnrp_lastresult($nnrp) {
		global $NNRP_GLOBAL_STATUS;

		return $NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULT"];
	}
	
	function nnrp_lastresulttext($nnrp) {
		global $NNRP_GLOBAL_STATUS;

		return $NNRP_GLOBAL_STATUS[$nnrp]["LASTRESULTTEXT"];
	}
?>
