<?php
/*************************************************************
 *  THE ADDRESS BOOK - RELOADED
 *  
 *  address.php
 *
 *  Displays address book entries.
 *
 *  GET:    id=123 ...                              id to be displayed
 *          [mode=view|edit|save|delete|trash|new]  what to do, default is view
 *
 *  Output: Full webpage with header and footer as generated by 
 *          address.inc.php and address-div.inc.php
 *
 *  Embed:  Uses classes PageContact and PageContactEditNew to
 *          display respective web-pages
 *
 *************************************************************/


    require_once('init.php');
    require_once('lib/backEnd/ErrorHandler.class.php');
    require_once('lib/backEnd/Options.class.php');
    require_once('lib/backEnd/Contact.class.php');
    require_once("lib/frontEnd/pages/PageContact.class.php");
    require_once("lib/frontEnd/pages/PageContactEdit.class.php");
    require_once("lib/frontEnd/pages/PageContactEditNew.class.php");
    require_once("lib/utilities/HTMLBeautifier.class.php");
    require_once("lib/utilities/RightsManager.class.php");
    require_once("lib/frontEnd/Image.class.php");

    // Is someone logged in?
    if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
        $errorHandler->standardError('NOT_LOGGED_IN',basename($_SERVER['SCRIPT_NAME']));
    
    // Set default mode, if necessary
    if (!isset($_GET['mode']))
        $_GET['mode'] = 'view';
    
    // Does user want to edit contact, but is admin-lock set?
    if ($_GET['mode'] != 'view' && $options->getOption('administrativeLock'))
        $errorHandler->error('adminLock');
    
    function newPageEditClass($id=null,$add=false)
    {
        global $CONFIG_OLD_EDIT_INTERFACE;
        
        if($CONFIG_OLD_EDIT_INTERFACE)
            return new PageContactEdit($id,$add);
        
        return new PageContactEditNew($id,$add);
    }

    function saveValueGroups(&$contact)
    {
        global $CONFIG_OLD_EDIT_INTERFACE, $errorHandler;
        
        $valGroups = array(
            'email',
            'phone',
            'chat',
            'www',
            'other',
            'date'
        );
        
        if($CONFIG_OLD_EDIT_INTERFACE)
        {            
            foreach ($valGroups as $vg) {
                if (isset($_POST[$vg])) {
                    $rows = explode("\n",StringHelper::cleanGPC($_POST[$vg]));
                    $valGroup = array();
                    
                    foreach ($rows as $r) {
                        if (!trim($r))
                            continue;
                            
                        $v = explode('|',$r);
                        
                        if (isset($v[2]) && ($v[2] = trim($v[2])) && $v[2] != '' && $v[2] != 'h' && $v[2] != 'a') {
                            $errorHandler->error('formVal','A different flag than h or a has been detected; please remove it or change it to h/a; the flag has been temporarily removed.');
                            $v[2] = '';
                        }
                        
                        if ($v[2] == 'a' && !$_SESSION['user']->isAtLeast('admin'))
                            continue;
                            
                        if ($vg == 'email' && $contact->isUser() && (($tmp = Contact::getContactFromEmail($v[0])) || ($tmp = User::getUserFromEmail($v[0]))) && (!isset($tmp['id']) || $tmp['id'] != $contact->contact['id']))
                            if (!isset($tmp['id']))
                                $errorHandler->error('formVal','The e-mail address ' . $v[0] . ' cannot be set, because it is in use by a user which is in the registration process.');
                            elseif (isset($tmp['hidden']) && $tmp['hidden'] && !$_SESSION['user']->isAtLeast('admin'))
                                $errorHandler->error('formVal','The e-mail address ' . $v[0] . ' cannot be set, because it is in use by a hidden contact.');
                            else
                                $errorHandler->error('formVal','The e-mail address ' . $v[0] . ' cannot be set, because it is in use by the contact <a href="contact.php?id=' . $tmp['id'] . '">' . $tmp['lastname'] . ', ' . $tmp['firstname'] . '</a>.');
                        
                        $valGroup[] = array(
                            'value' => trim($v[0]),
                            'label' => trim($v[1]),
                            'visibility' => ($v[2]?($v[2] == 'h'?'hidden':'admin-hidden'):'visible')
                        );
                        
                    }

                    $contact->setValueGroup($vg,$valGroup);
                }
            }
            
            return;
        }
        
        $valGroups[] = 'blank'; // special magic group for new entries
                    
        // sort value groups (user may reassign type of entry)
        foreach ($valGroups as $vg) 
        {
            if(isset($_POST[$vg]))
            {
                $valGroup = $_POST[$vg];
                for($i=0;$i<count($valGroup);$i++)
                {
                     // blank or value and label empty ... then delete the entry
                    if($valGroup[$i]['type']==' ' || (empty($valGroup[$i]['label']) && empty($valGroup[$i]['value'])))
                    {
                        unset($_POST[$vg][$i]);
                        continue;
                    }
                    
                    if($valGroup[$i]['type']!=$vg) // user changed type
                    {
                        $_POST[$valGroup[$i]['type']][] = $valGroup[$i]; // copy to appropriate array
                        unset($_POST[$vg][$i]);
                    }
                }
            }
        }
        
        // store everything ... that's the easiest
        foreach ($valGroups as $vg)
            if($vg!='blank' && isset($_POST[$vg]))
                $contact->setValueGroup($vg,StringHelper::cleanGPC($_POST[$vg]));
    }

    switch ($_GET['mode']) {
        // delete the contact
        case 'delete': 
            // is trash mode turned on??
            // if user is admin --> delete anyway
            if (!$options->getOption('deleteTrashMode') || $_SESSION['user']->isAtLeast('admin')) {
                // do we have an id??
                if (isset($_GET['id'])) {
                    $contact = new Contact(intval($_GET['id']));
                    // Is user really allowed to delete contact??
                    // Has effect only, if trash mode is turned off
                    if (!RightsManager::mayDeleteContact($_SESSION['user'],$contact))
                        $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
                    $contact->delete();
                    $errorHandler->error('ok','Contact permanently deleted.',basename($_SERVER['SCRIPT_NAME']));
                    require('list.php');
                } else
                    $errorHandler->error('invArg','No id is given');
            }
            // trash mode is turned on
        // do not add break
        // trash the contact
        case 'trash':
            if (isset($_GET['id'])) {
                // Do we have an id?
                $contact = new Contact(intval($_GET['id']));
                // May user trash contact??
                if (!RightsManager::mayDeleteContact($_SESSION['user'],$contact))
                    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
                $contact->trash();
                
                $errorHandler->error('ok','Contact marked for deletion. An administrator can edit, unhide and save the contact to restore it.',basename($_SERVER['SCRIPT_NAME']));
                if ($_SESSION['user']->isAtLeast('admin'))
                    $page = new PageContact($contact);
                else
                    require('list.php');
            } else
                $errorHandler->error('invArg','No id is given');
        break;
        // Save contact
        case 'save':
            // Is id given?
            if (isset($_POST['contact']['id'])) {
                // Load contact
                $contact = new Contact(intval($_POST['contact']['id']));
                // Is user allowed to edit that contact?
                if (!RightsManager::mayEditContact($_SESSION['user'],$contact))
                    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
            } else {
                // Is user allowed to add new contact?
                if (!$_SESSION['user']->isAtLeast('user'))
                    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
                // create new contact
                $contact = new Contact();
            }
                        
            // Clean up post-data recursively
            $data = StringHelper::cleanGPC($_POST['contact']);
            foreach ($data as $k => $v) {
                if ($k == 'pictureData')
                    continue;
                $contact->contact[$k] = $v;
            }
            
            if ($options->getOption('picAllowUpload')) {
                if (isset($_FILES['contact']['tmp_name']['pictureData']['file']) && $_FILES['contact']['tmp_name']['pictureData']['file']) {
                    $img = new Image($contact);
                    $contact->contact['pictureData'] = $img->resampleAndReturn($_FILES['contact']['tmp_name']['pictureData']['file']);
                } elseif (isset($_POST['contact']['pictureData']['remove']) && $_POST['contact']['pictureData']['remove']) {
                    $contact->contact['pictureData'] = '';
                }
            }
            
            $addr = StringHelper::cleanGPC($_POST['address']);
            if (isset($_POST['address_primary']))
                $addr[intval($_POST['address_primary'])]['primary'] = true;
            
            foreach ($addr as $k => $v) {
                $empty = true;
                foreach ($v as $d)
                    if (!empty($d)) {
                        $empty = false;
                        break;
                    }
                    
                if ($empty)
                    unset($addr[$k]);
                    
            }
            
            $contact->setValueGroup('addresses',$addr);
            
            saveValueGroups($contact);
                
            if (isset($_POST['groups']) || isset($_POST['newgroup'])) {
                $valGroup = array();
                if (isset($_POST['groups']))
                    foreach ($_POST['groups'] as $k => $v)
                        if ($v == '1')
                            $valGroup[]['groupname'] = $k;
                
                if (isset($_POST['newgroup']) && $_POST['newgroup'])
                    $valGroup[]['groupname'] = StringHelper::cleanGPC($_POST['newgroup']);
                        
                $contact->setValueGroup('groups',$valGroup);
            }
            
            if ($errorHandler->getErrors('formVal') || $errorHandler->getErrors('image'))
                $page = newPageEditClass($contact,!isset($_POST['contact']['id']));
            else {
            
                $contact->save();
                
                if ($errorHandler->getErrors('formVal'))
                    $page = newPageEditClass($contact,!isset($_POST['contact']['id']));
                else
                {
                    $errorHandler->error('ok','Changes successfully saved.',basename($_SERVER['SCRIPT_NAME']));
                    $page = new PageContact($contact->contact['id']); // force reload from mysql tables
                }                    
            }
        
        break;
        case 'edit':
            if (isset($_GET['id'])) {
                $contact = new Contact(intval($_GET['id']));
                if (!RightsManager::mayEditContact($_SESSION['user'],$contact))
                    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
                $page = newPageEditClass($contact);
            } else
                $errorHandler->error('invArg','No id is given');
        break;
        case 'new':
            if (!$_SESSION['user']->isAtLeast('user'))
                $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
            if (isset($_GET['id']))
            {
                $errorHandler->error('ok','Edit duplicate: The contact will be written to the database if you save. Make sure to change at least the name and verify other information to avoid duplicate entries in the database.');
                $page = newPageEditClass(intval($_GET['id']),true);
            }
            else
                $page = newPageEditClass(null,true);
        break;
        case 'incorrect': // report contact as incorrect
            if(isset($_GET['id']))
                $contact = new Contact(intval($_GET['id']));
                
            if(!empty($contact->contact['whoModified']))
            {
                $who = new User(intval($contact->contact['whoModified']));
                $who->sendEMail('Incorrect Entry',"A user reported this contact as incorrect.\nPlease carefully verify the following contact:\n" .
                    $CONFIG_TAB_ROOT . 'contact.php?id=' . $contact->contact['id']);
            }
            else
                $errorHandler->error('warning','No user has ever edited the contact. Please contact an administrator for help.');
            
            $page = new PageContact(intval($_GET['id']));
        break;
        default: // view contact
            if (!RightsManager::mayViewContact($_SESSION['user'],$contact))
                $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
            $page = new PageContact(intval($_GET['id']));
        break;
    }

    echo $page->create();
    
    exit();
    
?>
