<?php
/*************************************************************
 *  THE ADDRESS BOOK RELOADED 3.0
 *  
 *************************************************************
 *
 *  index.php
 *  Welcome screen
 *  
 *************************************************************/

// ** GET CONFIGURATION DATA *
    require_once('init.php');

    require_once('lib/frontEnd/pages/PageLoginScreen.class.php');
    require_once('lib/utilities/HTMLBeautifier.class.php');
        
    if(!isset($_GET['mode'])) // avoid undefined notice
        $_GET['mode']='';
    
    if ($_GET['mode'] == 'logout') {
        unset($_SESSION['user']);
        $options = new Options();
    }
    
    if ($_GET['mode'] == 'auth') { // Log the user in
        $_GET['mode'] = 'login';
        // do we have an email?
        if (!isset($_POST['user_email']) || !$_POST['user_email'])
            $errorHandler->error('login','Please enter an e-mail address');
        // is it not a number?
        elseif (is_numeric($_POST['user_email']))
            $errorHandler->error('login','This is not an e-mail address');
        else {
            // create user class with email
            $user = new User(StringHelper::cleanGPC($_POST['user_email']));
            // was the email correct?
            if ($user->id!==null) {
                // do we have a password
                if (!isset($_POST['user_password']) || !$_POST['user_password'])
                    $errorHandler->error('login','Please enter a password');
                // was the password correct?
                elseif ($user->login(StringHelper::cleanGPC($_POST['user_password']))) {
                    $_SESSION['user'] = &$user;
                    $options = new Options($user);
                    if ($user->getType() == 'register') {
                        if ($user->isConfirmed()) {
                            $_GET['mode'] = 'attachContact';
                            require('register.php');
                        } else {
                            unset($_SESSION['user']);
                            $options = new Options();
                        }
                    } else
                        $_GET['mode']='';
                    
                    
                }
            }
        }
        
    }

    if ($_GET['mode'] != 'login') {
        
        if (isset($_SESSION['user']) && $_SESSION['user']->isLoggedIn() || $options->getOption('requireLogin') != 1) {
        
            if (!(isset($_SESSION['user']) && $_SESSION['user']->isLoggedIn()))
                $_SESSION['user'] = new GuestUser();
            
            require('list.php');
        }
        
    }

    $page = new PageLoginScreen();
    echo $page->create();
    
    exit();

?>
