<?php
    // On some servers PHP does not display anything if config.php is missing
    ini_set('display_errors',true);
    // E_STRICT cannot be used because PHP5 has too many warnings
    error_reporting(E_ALL);

    require_once('config.php');
    require_once('constants.inc');

    require_once('lib/backEnd/DB.class.php');
    require_once('lib/backEnd/GuestUser.class.php');
    require_once('lib/backEnd/User.class.php');
    require_once('lib/backEnd/Options.class.php');
    require_once('lib/backEnd/ErrorHandler.class.php');
    require_once('lib/utilities/StringHelper.class.php');
    
    $db->query('SET CHARACTER SET utf8');
    mb_internal_encoding('utf8');
    
	mt_srand((double)microtime()*1000000);
    
    session_name('TheAddressBookSID');
    session_start();
    
    if (isset($_SESSION['user']) && !is_a($_SESSION['user'],'User'))
        unset($_SESSION['user']);
    
    if (isset($_SESSION['user']))
        $options = new Options($_SESSION['user']);
    else
        $options = new Options();
        
    if ($options->getOption('TABversion') != DB_VERSION_NO)
        $errorHandler->error('version','Your database version (' . $options->getOption('TABversion') . ') is not the one applicable for this code package (' . DB_VERSION_NO . '), please run an <a href="upgrade.php">upgrade</a>');
    
?>
