<?php

/**
* Contains class {@link DB DB}
*
* @package backEnd
* @author Tobias Schlatter
*/

/** */
require_once('lib/backEnd/ErrorHandler.class.php');

/**
* Represents a database
* 
* Handles database-connection opening, querying and data fetching;
* has also methods to backup database
*
* @package backEnd
*/
class DB {
    
    /**
    * @var int saves database connection
    */
    var $connection;
    
    /**
    * saves descriptors of open sql resources
    * @var array 
    */
    var $queries = array();
    
    /**
    * saves index in {@link $this->queries} of the last query made
    * @var integer|string 
    */
    var $last;
    
    /**
    * saves account data, used by {@link backup()}
    * @var array 
    */
    var $accData;
    
    /**
    * Opens DB connection and selects database
    * @param string $location Location of the database-server
    * @param string $user Username used to log in
    * @param string $password Password used to log in
    * @param string $database Name of the Database
    * @global ErrorHandler Used to report errors
    */
    function DB($location,$user,$password,$database) {
        global $errorHandler;
        
        if (!$this->connection = @mysql_connect($location,$user,$password))
            $errorHandler->error('db',"Failed to connect to database $location: " . mysql_error());
            
        if (!@mysql_select_db($database,$this->connection))
            $errorHandler->error('db',"Failed to select database $database: " . mysql_error());
            
        @ini_set('magic_quotes_runtime','0');
        
        $this->accData = array(
            'user' => $user,
            'location' => $location,
            'password' => $password,
            'database' => $database
        );
        
    }
    
    /**
    * Queries the database and ignores errors
    *
    * Mainly to be used in upgrade queries, which may have been carried out already
    * after calling this function, you will NOT be able to fetch results, query insertIDs
    * or the rows which were affected
    * @param string $sql SQL to be used to query the database
    * @return boolean true on success
    */
    function queryNoError($sql) {
        return @mysql_query($sql,$this->connection);
    }
    
    /**
    * Queries the database
    * @param string $sql SQL to be used to query the database
    * @param integer|string $id Index in {@link $this->queries} where the result should be saved
    * @global ErrorHandler Used to report errors
    */
    function query($sql,$id=0) {
        global $errorHandler;
        
        if (!$this->queries[$id] = @mysql_query($sql,$this->connection))
            $errorHandler->error('db','Failed to do query: ' . mysql_error() . '<br />In query: ' . $sql);
            
        $this->last = $id;
        
    }
    
    /**
    * Fetches next row of a query
    * @param integer|string $id Index of query
    * @return array Associative array with one row data or null 
    */
    function next($id=0) {
        if (ini_get('magic_quotes_runtime') == '0')
            return @mysql_fetch_array($this->queries[$id]);
        else
            return $this->unescape(@mysql_fetch_array($this->queries[$id]));
    }
    
    /**
    * Frees query memory (only needed with big queries)
    * @param integer|string $id Index of query
    */
    function free($id=0) {
        @mysql_free_result($this->queries[$id]);
    }
    
    /**
    * Returns affected rows or number of rows returned
    *
    * This function unions two mysql functions in one. It uses
    * {@link mysql_affected_rows() mysql_affected_rows()} if the last query wasn't a query that yielded a
    * result, and it uses {@link mysql_num_rows() mysql_num_rows()} if an id was given, or the
    * last query returned a result
    * @param $id Index of query to return row number
    * @global ErrorHandler Used to report errors
    * @return integer Number of rows
    */
    function rowsAffected($id=0) {
        global $errorHandler;
        
        if ($this->queries[$id] === TRUE)
            if ($id != $this->last)
                $errorHandler->error('db','Tried to get affected rows of non-last, non-result query!');
            else
                return @mysql_affected_rows($this->connection);
        else
            return @mysql_num_rows($this->queries[$id]);
    }
    
    /**
    * Returns last auto increment value
    *
    * This function is needed for INSERT queries which insert in a table with
    * auto increment value, if the id is needed later.
    * @return integer Id of last inserted row
    */
    function insertID() {
        return @mysql_insert_id($this->connection);
    }
    
    /**
    * Escapes strings and binary data to be inserted in the database
    * WARNING: this function will convert numeric strings to numbers (0.8 -> 0.8000000)!
    *
    * If the function {@link mysql_real_escape_string() mysql_real_escape_string()} exists, it will be used;
    * otherwise the old and deprecated function {@link mysql_escape_string() mysql_escape_string()} is used
    * @param string $val String to escape
    * @staticvar boolean Caches, if {@link mysql_real_escape_string() mysql_real_escape_string()} exists or not
    * @return string Escaped string
    */
    function escape($val) {
        if (is_numeric($val))
            return $val;

        static $real=NULL;
        if ($real === NULL)
            $real = function_exists('mysql_real_escape_string');

        if ($real)
            return "'" . mysql_real_escape_string($val,$this->connection) . "'";
        else
            return "'" . mysql_escape_string($val) . "'";
    }
    
    /**
    * Unescapes string or array of results. Useful, if magic_quotes_runtime is turned on
    *
    * The PHP "feature" magic_quotes is capable of quoting data, returned from functions
    * such as {@link mysql_fetch_array() mysql_fetch_array()}, this function unescapse it again, if needed
    * @static
    * @param string $val string to be unescaped
    * @return string unescaped string
    */
    function unescape($val) {
        if (!is_array($val))
            return stripslashes ($val);
            
        $ret = $val;
        foreach ($ret as $k => $v)
            $ret[$k] = $this->unescape($v);
            
        return $ret;
    }
    
    /**
    * Dumps the database and outputs it to the server
    *
    * Because of php-safe-mode, some ifs are required, to ensure the command is not
    * escaped twice
    * 
    * @global ErrorHandler Used to report errors
    */
    function backup() {
        
        global $errorHandler;
        
        if (ini_get('safe_mode') && (
            strpos($this->accData['location'],' ') !== false ||
            strpos($this->accData['user'],' ') !== false ||
            strpos($this->accData['password'],' ') !== false ||
            strpos($this->accData['database'],' ') !== false))
                $errorHandler->error('invArg','One of the database-variables contains spaces');
                
        
        header('Content-type: application/plain; charset=UTF-8');
        header('Content-Disposition: attachment; filename="tab_db_backup_' . date('Y-m-d_H:i:s') . '.sql"');
        header("Cache-Control: no-store, no-cache, must-revalidate");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        header("Expires: 0");

        if (ini_get('safe_mode'))
            passthru('mysqldump --opt' .
            ' --host=' . $this->accData['location'] .
            ' --user=' . $this->accData['user'] .
            ' --password=' . $this->accData['password'] .
            ' --databases ' . $this->accData['database']);
        else
            passthru('mysqldump --opt' .
            ' --host=' . escapeshellarg($this->accData['location']) .
            ' --user=' . escapeshellarg($this->accData['user']) .
            ' --password=' . escapeshellarg($this->accData['password']) .
            ' --databases ' . escapeshellarg($this->accData['database']));
        
    }
    
}

/**
* @global DB $db
*/
$db = new DB($db_hostname, $db_username, $db_password, $db_name);

?>
