<?php
/**
* contains class {@link DateContactList}
* @package backEnd
* @author Tobias Schlatter
*/

/** */
require_once('lib/backEnd/DB.class.php');
require_once('lib/backEnd/ContactList.class.php');

/**
* a list of contacts, selected by the time until they will have their birthday
* @package backEnd
*/
class DateContactList extends ContactList {
    
    /**
    * @var integer how many days before the birthday change should be shown
    */
    var $daysBefore;
    
    /**
    * @var array cache the dates selected from database
    */
    var $dates;
    
    /**
    * Constructor
    * 
    * intializes the class with values, calls parent constructor
    * @param integer $daysBefore how many days should a contact entry be shown before his birthday
    */
    function DateContactList($daysBefore) {
        
        $this->daysBefore = $daysBefore;
        
        $this->ContactList('');
        
        $this->resetQuery();
        
    }
    
    /**
    * set days before
    * 
    * set how many days before the birthday a contact entry should be shown
    * @param integer $daysBefore day count
    */
    function setDaysBefore($daysBefore) {
        $this->daysBefore = $daysBefore;
        resetQuery();
    }
    
    /**
    * returns the dates, belonging to the contacts in the same order
    * @return array list of associative arrays with info about the dates
    */
    function getDates() {
        $this->getContacts();
        return $this->dates;
    }
    
    /**
    * deletes the data
    */
    function resetResults() {
        $this->dates = array();
        parent::resetResults();
    }
    
    /**
    * processes each row returned from db
    *
    * overrides function from {@link ContactList};
    * saves the dates from db to {@link $dates}, then passes
    * contoll to {@link ContactList::processQueryResults()}
    */
    function processQueryResult($r) {
        $this->dates[] = array(
            'type' => $r['label'],
            'daysAway' => $r['daysAway'],
            'day' => $r['day'],
            'month' => $r['month'],
            'year' => $r['year']
        );
        parent::processQueryResult($r);
    }
    
    /**
    * reset the query (used if a value has changed)
    * @global DB used for data escaping
    */
    function resetQuery() {
        
        global $db;
        
        $this->setSQLQuery('SELECT *,
            (TO_DAYS((value + INTERVAL (YEAR(CURRENT_DATE)-YEAR(value) + (RIGHT(CURRENT_DATE,5)>RIGHT(value,5)) ) YEAR)) - TO_DAYS(CURRENT_DATE)) AS daysAway,
            MONTH(value) AS month, 
            DAYOFMONTH(value) AS day,
            YEAR(value) AS year
            FROM ' . TABLE_DATES . ' as dates, ' . TABLE_CONTACT . ' AS contact
            WHERE hidden != 1' . ($this->daysBefore >= 0? ' AND visibility = ' . $db->escape('visible') . ' AND contact.id = dates.id AND
            (TO_DAYS((value + INTERVAL (YEAR(CURRENT_DATE)-YEAR(value) + (RIGHT(CURRENT_DATE,5)>RIGHT(value,5)) ) YEAR)) - TO_DAYS(CURRENT_DATE)) <
            ' . $db->escape($this->daysBefore):'') . '
            ORDER BY daysAway ASC, lastname ASC, firstname ASC'
        );
        
    }
    
    
}



?>
