<?php

/**
* contains class {@link Navigation}
* 
* @author Tobias Schlatter
* @package frontEnd
*/


/**
* class representing navigation
* 
* handles addition of entries and sub-entries,
* removal of entries is also possible
* @package frontEnd
*/
class Navigation {
    
    /**
    * @var array associative array, used to save the links
    */
    var $content;
    
    /**
    * Constructor
    * 
    * creates new, empty navigation
    */
    function Navigation() {
        $this->content = array();
    }
    
    /**
    * add a new top-level entry to the navigation
    * @param integer|string $id unique identifier of the entry
    * @param string $caption displayed value of the link
    * @param string $href link target
    */
    function addEntry($id,$caption,$href) {
        $this->content[$id]['caption'] = $caption;
        $this->content[$id]['href'] = $href;
    }
    
    /**
    * remove a top-level entry
    * @param integer|string $id the identifier of the entry to remove
    */
    function removeEntry($id) {
        unset($this->content[$id]);
    }
    
    /**
    * add a sub entry to a top-level entry
    * @param integer|string $parentID the identifier of the entry, to which the sub-entry should be added
    * @param string $caption displayed value of the link
    * @param string $href link target
    */
    function addSubEntry($parentID,$caption,$href) {
        $this->content[$parentID][] = array(
            'caption' => $caption,
            'href'    => $href
        );
    }
    
    /**
    * creates html from currently saved links
    * 
    * creates a navigation based on nested &lt;ul&gt;'s. Formatting has to be done with css
    * @param string $class css class for the top-level &lt;ul&gt;
    * @return string html for the navigation
    */
    function create($class='',$opening=true) {
        
        if (empty($this->content) || count($this->content) <= 0)
            return '';
        
        $cont = '<ul' . ($class?' class="' . $class . '"':'') . ">\n";
        
        foreach ($this->content as $v) {
            
            $cont .= '<li' . ($opening?' onmouseover="einblenden(this);" onmouseout="ausblenden(this);"':'') . '><a href="' . $v['href'] . '">' . $v['caption'] . "</a>\n";
            
            if (isset($v[0])) {
                $cont .= "<ul>\n";
                $i = 0;
                while (isset($v[$i])) {
                    $cont .= '<li><a href="' . $v[$i]['href'] . '">' . $v[$i]['caption'] . "</a></li>\n";
                    $i++;
                }
                $cont .= "</ul>\n";
            }
            
            $cont .= "</li>\n";
            
        }
        
        $cont .= "</ul>\n";
        
        return $cont;
        
    }
    
}

?>
