<?php

/**
* contains class {@link Page}
* @author Tobias Schlatter
* @package frontEnd
*/

/**
* super-class of every page displayed in tab
* 
* this class is used create everything that should be displayed on every page of tab (e.g. footer)
* @package frontEnd
*/

class Page {
    
    /**
    * @var string saves the title of the page
    */
    var $title;
    
    /**
    * Constructor
    * 
    * initializes {@link $title}
    * @param string $title the title of the page, normally something is added before this title
    */
    function Page($title) {
        $this->title = $title;
    }
    
    /**
    * creates the html of the whole page
    * @return string html of page
    * @uses innerCreate() used to create the actual content of the page
    * @global string additional footer info of page
    */
    function create() {
        
        global $CONFIG_FOOTER_HTML, $CONFIG_TAB_SERVER_ROOT, $CONFIG_HEADER_HTML, $CONFIG_ADD_HEAD, $errorHandler;
        
        header('Content-Type: text/html; charset=UTF-8',true);
        
        $cont = <<<EOC
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" --"http://www.w3.org/TR/REC-html40/strict.dtd"-->
<html>
    <head>
        <title>The Address Book - 
EOC;
        $cont .= $this->title;
        $cont .= <<<EOC
</title>
        <link rel="stylesheet" href="
EOC;
        
        $cont .= Page::getStyleFile();
        $cont .= '" type="text/css" />';
        $cont .= <<<EOC

        <meta http-equiv="cache-control" content="no-cache" />
        <meta http-equiv="pragma" content="no-cache" />
        <meta http-equiv="expires" content="-1" />
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="robots" content="noindex, nofollow" />
        <script type="text/javascript"
        <!--
            var InternetExplorer = false;
        //-->
        </script>
        <!--[if IE]>
        <script type="text/javascript">
        <!--
            InternetExplorer = true;
        //-->
        </script>
        <![endif]-->
EOC;
        $cont .= '<script type="text/javascript" src="' . $CONFIG_TAB_SERVER_ROOT . 'lib/js/scriptaculous/prototype.js"></script>';
        $cont .= '<script type="text/javascript" src="' . $CONFIG_TAB_SERVER_ROOT . 'lib/js/scriptaculous/scriptaculous.js"></script>';
        $cont .= '<script type="text/javascript" src="' . $CONFIG_TAB_SERVER_ROOT . 'lib/js/cookie.js"></script>';
        $cont .= '<script type="text/javascript" src="' . $CONFIG_TAB_SERVER_ROOT . 'lib/js/contactEdit.js"></script>';
        $cont .= '<script type="text/javascript" src="' . $CONFIG_TAB_SERVER_ROOT . 'lib/js/iexHover.js"></script>';
        $cont .= $CONFIG_ADD_HEAD;
        $cont .= '</head>';
        $cont .= '<body>';

        $cont .= $CONFIG_HEADER_HTML;
        
        $cont .= $this->errorCreate($errorHandler);
        $cont .= $this->innerCreate();

        $cont .= <<<EOC
        
        <div id="footer">
        <p id='f_version'>The Address Book Reloaded version: 
EOC;
        $cont .= VERSION_NO . " | <a href=\"" . URL_HOMEPAGE . "\" target=\"_blank\">homepage</a> | <a href=\"" . URL_SOURCEFORGE . "\" target=\"_blank\">sourceforge</a></p>";
        $cont .= <<<EOC

            <p id='f_copy'>&copy; 2001-2005 Infinity Plus One Productions. All rights reserved.</p>
            <p id='f_gnu'>This application is distributed under the <a href='gpl.html'>GNU General Public Licence</a>.</p>
            <p id='f_extra'>
EOC;
        $cont .= $CONFIG_FOOTER_HTML;
        $cont .= <<<EOC

            </p>
        </div>
    </body>
</html>
EOC;

        return $cont;
    }
    
    /**
    * returns the path to the style file, according to {@link $CONFIG_STYLE}
    *
    * this method checks, whether the requested style is available or not,
    * if it is available it returns the path to that style, otherwise it returns
    * the path to the default style
    * @global Options admin options
    * @global string absolute server path (not filesystem) to project
    * @return string path to css file
    * @static
    */
    function getStyleFile() {
        global $options, $CONFIG_TAB_SERVER_ROOT;
        
        if(is_object($options)) // upgrade.php does not have options
        {
            $inc = $options->getOption('interfaceStyle') . ".css";
    
            // Override location if file is missing
            if(file_exists('styles/' . $inc))
                return $CONFIG_TAB_SERVER_ROOT . 'styles/' . $inc;
        }
            
        return $CONFIG_TAB_SERVER_ROOT . 'styles/default.css';

    }
    
    /**
    * this function returns the actual content of a page
    * 
    * this function is overloaded by superclasses of page to return
    * the content they need
    * @return string html-content of page
    */
    function innerCreate() {}
    
    /**
    * this function creates the error/OK message(s) on top of a page. Called immediately before inner create.
    * This function can be overloaded by a subclass to change error output. CSS: error-notice, error-ok
    * @return string html-content of page
    */
    function errorCreate(&$errorHandler)
    {
        $cont='';
        foreach ($errorHandler->getErrors() as $err)
            if($err['type']!='ok')
                $cont .= '<div class="error-notice">' . $errorHandler->errorString($err) . '</div>';
            else
                $cont .= '<div class="error-ok">' . $errorHandler->errorString($err) . '</div>';
                
        return $cont;
    }
}

?>
