<?php

/**
* contains class {@link PageContact}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Navigation.class.php');
require_once('lib/frontEnd/Image.class.php');
require_once('lib/frontEnd/Page.class.php');
require_once('lib/backEnd/Contact.class.php');
require_once('lib/backEnd/PluginManager.class.php');
require_once('lib/utilities/AddressFormatter.class.php');
require_once('lib/utilities/RightsManager.class.php');

/**
* the contact entry page
* 
* the contact entry page shows one
* contact at a time with all information provided
* @package frontEnd
* @subpackage pages
* @uses Contact
*/
class PageContact extends Page {
    
    /**
    * @var Contact the contact to show
    */
    var $contact;
    
    /**
    * @var Navigation the menu for the contact-card
    */
    var $cardMenu;
    
    /**
    * @var Navigation the menu generated by plugins
    */
    var $pluginMenu;
    
    /**
    * @var Image the mugshot of the contact
    */
    var $image;
    
    /**
    * Constructor
    * 
    * init superclass, create navigation, init variables {@link $contact}, {@link $cardMenu}, {@link $pluginMenu} and {@link $image}
    * if passed value is an integer, the contact with this id is loaded, else it is considered as the contact class itself
    * @param integer|Contact $id contact or contact id
    * @global Options used to determine options
    * @global PluginManager used to generate plugin menu
    */
    function PageContact($id) {
    
        global $options, $pluginManager;
        
        if (is_numeric($id))
            $this->contact = new Contact($id);
        else
            $this->contact = &$id;
        
        $this->Page('Contact for ' . $this->contact->contact['firstname'] . ' ' . $this->contact->contact['lastname']);
        
        // Create Menue
        $this->cardMenu = new Navigation();
        $this->cardMenu->addEntry("list","list","list.php");

        if (RightsManager::mayEditContact($_SESSION['user'],$this->contact))
            $this->cardMenu->addEntry("edit","edit","contact.php?mode=edit&amp;id={$this->contact->contact['id']}");
        
        $this->cardMenu->addEntry("print","print","javascript:window.print()");
        
        $this->cardMenu->addEntry("incorrect","incorrect","javascript:reportIncorrectEntry({$this->contact->contact['id']},'Are you sure you want to report this entry as incorrect? This will automatically generate an email to the person who last edited the contact.')");
        
        if ($_SESSION['user']->isAtLeast('admin') && !$this->contact->isUser())
            $this->cardMenu->addEntry('cuser','create user',"register.php?mode=cuser&amp;id={$this->contact->contact['id']}");
        
        // Create Plugin Menue
        $this->pluginMenu = new Navigation();
        $pluginManager->contactMenu($this->contact,$this->pluginMenu);
        
        $this->image = new Image($this->contact);
    
    }
    
    /**
    * create the content of contact-card
    * @return string html-content
    * @global PluginManager used for custom menues
    * @global Options
    */
    function innerCreate() {

        global $pluginManager, $options;
        
        $cont = '';

        $cont .= '<div class="card">';
        $cont .= $this->cardMenu->create('card-menu');  

        $cont .= $this->pluginMenu->create('card-pluginmenu');
        
        $cont .= $this->contact->names();
        
        $cont .= $this->contact->groups();
        
        $cont .= '<div class="card-box">';
        $cont .= '<div class="card-box-tr"></div><div class="card-box-tl"></div>'; // rounded corner etc.
        
        $cont .= '<div class="card-top">';
        
        $cont .= $this->image->html('card-picture');
        
        $cont .= $this->contact->addresses();
        
        // Output emphomess
        $cont .= '<div class="card-emphomess">';
            $cont .= $this->contact->emails();
            $cont .= $this->contact->phones();
            $cont .= $this->contact->messaging();
        $cont .= '</div>';
        
        
        // close card top
        $cont .= '</div>';
        
        $cont .= '<div class="card-bottom">';
            $cont .= $this->contact->dates();
            $cont .= $this->contact->additionals();
            $cont .= $this->contact->webs();
            $cont .= $pluginManager->contactOutput($this->contact, 'beforeNotes');
            $cont .= $this->createUserInfo();
            $cont .= $this->contact->notes();
        $cont .= '</div>';
        
        $cont .= '<div class="card-box-br"></div><div class="card-box-bl"></div>'; // rounded corner etc.
        $cont .= '</div>';
        
        if(isset($this->contact->contact['whoModified']))
        {
            $who = new User(intval($this->contact->contact['whoModified']));
            $link = ' by <a class="update" href="contact.php?id=' . $who->contact['id'] . '">' . $who->contact['lastname'] . ', ' . $who->contact['firstname'] . '</a>';
        }
        else
            $link='';
        
        $cont .= '<div class="update">This entry was last updated on ' . $this->contact->contact['lastUpdate'] . $link . '</div></div>';
        
        return $cont;

    }
    
    /**
    * create html info, if current contact is also a user
    * @return string html-content
    * @todo find better solution than style tag in html
    */
    function createUserInfo() {
        $cont = '';
        if ($this->contact->isUser()) {
            $user = new User($this->contact->isUser());
            if ($_SESSION['user']->contact['id'] == $this->contact->contact['id']) {
                $cont .= '<div class="user-info"><span class="user-info-title">This is you</span><span class="user-info-info"><a href="options.php">show/change my settings</a></span></div>';
                if ($_SESSION['user']->isAtLeast('admin'))
                    $cont .= '<div class="user-info"><span class="user-info-title">User type</span><span class="user-info-info"><a href="#" onclick="effect_1 = Effect.SlideDown(\'userChanger\',{duration:1.2}); return false;">' . $user->getType() . '</a></span></div>';
                else
                    $cont .= '<div class="user-info"><span class="user-info-title">User type</span><span class="user-info-info">' . $user->getType() . '</span></div>';
            } elseif ($_SESSION['user']->isAtLeast('admin')) {
                $cont .= '<div class="user-info"><span class="user-info-title">This is a user</span><span class="user-info-info"><a href="options.php?userid=' . $this->contact->isUser() . '">show/change settings</a></span></div>';
                $cont .= '<div class="user-info"><span class="user-info-title">User type</span><span class="user-info-info"><a href="#" onclick="effect_1 = Effect.SlideDown(\'userChanger\',{duration:1.2}); return false;">' . $user->getType() . '</a></span></div>';
            }
            if ($_SESSION['user']->isAtLeast('admin'))
############# style TAG!!!!!
                $cont .= '<div class="user-info" id="userChanger" style="display: none;"><span class="user-info-title"></span><span class="user-info-info">Change:
                    <a href="saveadmin.php?mode=chtype&amp;userid=' . $this->contact->isUser() . '&amp;type=admin">admin</a>
                    <a href="saveadmin.php?mode=chtype&amp;userid=' . $this->contact->isUser() . '&amp;type=manager">manager</a>
                    <a href="saveadmin.php?mode=chtype&amp;userid=' . $this->contact->isUser() . '&amp;type=user">user</a>
                    <a href="saveadmin.php?mode=chtype&amp;userid=' . $this->contact->isUser() . '&amp;type=guest">guest</a>
                </span></div>';
            }
        if ($cont != '')
            return '<div class="other-spacer"></div>' . $cont;
        else
            return '';
    }
    
}

?>
