<?php
/**
* contains class {@link PageAdminPanel}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Page.class.php');

/**
* the error page
* 
* this page is used to show fatal errors
* it is used ONLY by the {@link ErrorHandler}, if a fatal error occurs.
* This page is NOT to be used directly
* @package frontEnd
* @subpackage pages
*/
class PageError extends Page {

    /**
    * @var ErrorHandler
    */
    var $errorHandler;
    var $error; //cache
    
    /**
    * Constructor
    *
    * init superclass, according to error type, also init the two class vars
    * @param ErrorHandler global errorHandler
    * @param string $cause error type specific string
    */
    function PageError($errorHandler) { // this should prevent people from using this class directly
        
        $this->errorHandler = $errorHandler;
        $this->error = $this->errorHandler->getLastError();
        switch ($this->error['type']) {
            case 'db':
                $this->Page('Database Error');
            break;
            case 'noLogin':
                $this->Page('Login Error');
            break;
            case 'adminLock':
                $this->Page('Administrative Lock');
            break;
            case 'install':
                $this->Page('Installation Error');
            break;
            case 'plugin':
                $this->Page('Plugin Error');
            break;
            case 'noFile':
                $this->Page('File not Found');
            break;
            case 'internal':
                $this->Page('Internal Assertion Error');
            break;
            default:
                $this->Page('Error');
            break;
        }
    }

    /**
    * create error page according to error that occured
    * @return string html-content
    */
    function innerCreate() {
        global $CONFIG_TAB_ROOT;
        
        $cont = <<<EOC
        <div class="error-box">
EOC;

        switch ($this->error['type']) {
            case 'db':
                $cont .= '<div class="error-title">An error in the database occured:</div>';
                $cont .= '<div class="error-body">' . $this->errorHandler->errorString() . '</div>';
            break;
            case 'noLogin':
                $cont .= '<div class="error-title">An error with your login occured:</div>';
                $cont .= '<div class="error-body">' . $this->errorHandler->errorString() . '</div>';
            break;
            case 'adminLock':
                $cont .= '<div class="error-title">Administrative lock:</div>';
                $cont .= '<div class="error-body">TAB is currently locked, due to maintainance. You may not edit or delete any entries. Please retry later.</div>';
            break;
            case 'install':
                $cont .= '<div class="error-title">During installation the following error occurred:</div>';
                $cont .= '<div class="error-body">' . $this->errorHandler->errorString() . '</div>';
            break;
            case 'noFile':
                $cont .= '<div class="error-title">File not found:</div>';
                $cont .= '<div class="error-body">The file ' . $this->errorHandler->errorString() . ' could not be found.</div>';
            break;
            default:
                $cont .= '<div class="error-title">The following error occurred:</div>';
                $cont .= '<div class="error-body">' . $this->errorHandler->errorString() . '</div>';
            break;
        }

        $cont .= <<<EOC
        <div class="error-footer">
        If necessary, please press the BACK button on your browser to return to the previous screen and correct any possible mistakes. 
        You can also try the following actions that might solve your problem:
        <ul>
EOC;
        $cont .= '<li><a href="'.$CONFIG_TAB_ROOT.'index.php?mode=login">login</a></li>';
        $cont .= '<li><a href="'.$CONFIG_TAB_ROOT.'index.php?mode=logout">logout</a></li>';
        $cont .= '<li><a href="'.$CONFIG_TAB_ROOT.'upgrade.php">upgrade</a></li>';
        $cont .= '<li><a href="'.$CONFIG_TAB_ROOT.'list.php">main list</a></li>';
        $cont .= <<<EOC
        </ul>
        <br />If you still need help, or you believe this to be a bug, copy the calling URL from the browser <b>NOW</b> and then please consult the <a href="https://sourceforge.net/tracker/?group_id=172286&atid=861161" target="_blank">Bug Tracker</a>.
        </div>
        </div>        
EOC;

        return $cont;

    }
    
    /*
    * Overridde to suppress standard error message, but this would suppress other notices before...?
    function errorCreate(&$errorHandler) { return ''; }
    */
}

?>
