<?php
/**
* contains class {@link PageFeatureList}
* @author Thomas Katzlberger
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Page.class.php');
require_once('lib/utilities/TableGenerator.class.php');

/**
* this is a ranklist that displays a ranking for a group of people
* 
* @package frontEnd
* @subpackage pages
* @uses DateContactList
*/
class PageFeatureList extends Page {

    var $featureLabel,$ascending,$limit;
    
    /**
    * Constructor
    * 
    * init superclass, init {@link $contactList}
    * @global Options determine how many days after change the contact should still be shown
    */
    function PageFeatureList($featureLabel,$ascending=false,$limit=0) {
        
        $this->Page('Feature List');
        $this->featureLabel=$featureLabel;
        $this->ascending=$ascending;
        $this->limit=$limit;
    }
    
    /**
    * create the content of recently changed
    * @return string html-content
    * @global Options determine how many days after change the contact should still be shown
    * @param boolean $compact whether list should be displayed with imported link and user who changed contact
    */
    function innerCreate() {
        
        global $options;
        global $db;
        
        $db->query('SELECT *
            FROM ' . TABLE_CONTACT . ' AS contact, ' . TABLE_PROPERTIES . " AS prop 
            WHERE contact.id=prop.id AND prop.label=" . $db->escape($this->featureLabel) . '
            ORDER BY prop.value ' . ($this->ascending ? 'ASC' : 'DESC') . ($this->limit > 0 ? ' LIMIT '.$this->limit : ''));

        $data = array();
        
        while($c = $db->next()) {
            
            $data[] = array(
                'display_name' => '<a href="contact.php?id=' . $c['id'] . '">' . $c['lastname'] . ', ' . $c['firstname'] . '</a>',
                'feature' => $c['value']
            );
            
        }
        
        $tGen = new TableGenerator('changed-list');
        
        $cont = '<table class="changed-list">';
        
        $cont .= '<caption>Ranklist';
         
        $cont .= '</caption>';
        
        if (count($data) > 0)
            $cont .= $tGen->generateBody($data,array('display_name','feature'));
        else
            $cont .= '<tr class="noentry"><td>Not found</td></tr>';
        
        $cont .= '</table>';
        
        if (!$compact)
            $cont .= '<div><a href="list.php">return</a></div><br>';
        
        return $cont;
        
    }

}

?>
