<?php
/**
* contains class {@link PageLoginScreen}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Page.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');
require_once('lib/backEnd/Options.class.php');

/**
* the login screen
* 
* the login screen is the first page that is displayed
* it shows links to register users and to recover lost passwords
* @package frontEnd
* @subpackage pages
*/
class PageLoginScreen extends Page {
    
    /**
    * Constructor
    * 
    * init superclass
    */
    function PageLoginScreen() {
        $this->Page('Login Screen');
    }
    
    /**
    * create the content of login page
    * @return string html-content
    * @global Options used to determine login message and whether to display register link
    * @global ErrorHandler used for error handling
    */
    function innerCreate() {
        
        global $options, $errorHandler;
        
        $cont = <<<EOC
        <div class="login-form">
        <img src="images/banner.png" class="tab-title" alt="The Address Book" />
EOC;
        if ($options->getOption('msgLogin') != '')
            $cont .= '<div class="login-message">' . $options->getOption('msgLogin') . '</div>';
            
        $err = $errorHandler->getLastError('login');
        if ($err)
            $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
            
        $cont .= <<<EOC
        <form method="post" action="index.php?mode=auth">
        <div><label for="user_email">E-Mail</label></div>
        <div><input type="text" name="user_email" id="user_email" size="40" /></div>
        <div><label for="user_password">Password</label></div>
        <div><input type="password" name="user_password" id="user_password" size="40" /></div>
        <div><input type="submit" value="login" /></div>
        </form>
EOC;
        $cont .= '<div class="login-register"><a href="register.php?mode=lostpasswd">lost password</a></div>';

        if ($options->getOption('allowUserReg') != 'no')
            $cont .= '<div class="login-register"><a href="register.php?mode=register">Register</a></div>';

        if ($options->getOption('requireLogin') != 1)
            $cont .= '<div class="login-guest"><a href="list.php">Enter as a guest</a></div>';
        
        $cont .= '</div>';

        return $cont;

    }
    
    /**
    * We overridde this to relocate standard error message output
    */
    function errorCreate(&$errorHandler)
    {
        return '';
    }
}

?>
