<?php

/**
* contains class {@link PageOptions}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Page.class.php');
require_once('lib/frontEnd/Navigation.class.php');
require_once('lib/backEnd/DB.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');
require_once('lib/utilities/TableEditor.class.php');

/**
* the options
* 
* the options page allows users to change their personal options
* it also allows administrators to change and view options of other users
* @package frontEnd
* @subpackage pages
*/
class PageOptions extends Page {
    
    /**
    * @var Navigation the navigation of the option panel
    */
    var $nav;
    
    /**
    * @var User user for which to display the panel (current user, if null)
    */
    var $user;
    
    /**
    * Constructor
    * 
    * init superclass, create navigation, init {@link $user}
    */
    function PageOptions($user=null) {
        $this->Page('Options');
        $this->nav = new Navigation();
        
        if ($user === null)
            $this->nav->addEntry('return','return','list.php');
        else
            $this->nav->addEntry('return','return','contact.php?id=' . $user->contact['id']);
        
        $this->user = $user;
        
    }
    
    /**
    * create the content of the options page
    * @return string html-content
    * @global ErrorHandler used for error handling
    * @uses createPasswordForm()
    * @uses createEmailForm()
    * @uses createOptionsForm()
    */
    function innerCreate() {
        
        global $errorHandler;
        
        $cont = '<div class="options">';
        
        $cont .= $this->nav->create('options-menu');
        
        if ($this->user)
            $cont .= '<div class="options-title">Edit the options of ' . $this->user->contact['lastname'] . ', ' . $this->user->contact['firstname'] . '</div>';
        else
            $cont .= '<div class="options-title">Edit your options</div>';
        
        $cont .= '<div class="options-box">';
        
        $cont .= $this->createPasswordForm();
        $cont .= $this->createEmailForm();
        $cont .= $this->createOptionsForm();
        
        $cont .= '</div>';
        $cont .= '</div>';
        
        return $cont;
        
    }
    
    /**
    * create the form needed to change password
    * @return string html-content
    */
    function createPasswordForm() {
    
        $cont = '<form action="options.php?mode=password' . ($this->user!==null?'&amp;userid=' . $this->user->id:'') . '" method="post">';
        $cont .= '<fieldset class="options-password">';
        $cont .= '<legend>Change password</legend>';
        
        $cont .= '<div><label for="oldPassword">Old password</label><input type="password" name="oldPassword" id="oldPassword" /></div>';
        $cont .= '<div><label for="newPassword1">New password</label><input type="password" name="newPassword1" id="newPassword1" /></div>';
        $cont .= '<div><label for="newPassword2">Repeat</label><input type="password" name="newPassword2" id="newPassword2" /></div>';
        $cont .= '<div><input type="submit" value="change password" /></div>';
        
        $cont .= '</fieldset>';
        $cont .= '</form>';
        
        return $cont;
    
    }
    
    /**
    * create the form needed to change email
    * @return string html-content
    */
    function createEmailForm() {
    
        $cont = '<form action="options.php?mode=email' . ($this->user!==null?'&amp;userid=' . $this->user->id:'') . '" method="post">';
        $cont .= '<fieldset class="options-email">';
        $cont .= '<legend>Change e-mail address</legend>';
        
        $cont .= '<div><label for="email">New e-mail address</label><input type="text" name="email" id="email" size="50"/></div>';
        $cont .= '<div><input type="submit" value="change e-mail" /></div>';
        
        $cont .= '</fieldset>';
        $cont .= '</form>';
        
        return $cont;
    
    }
    
    /**
    * create the personal options options form, using the {@link TableEditor}
    * 
    * {@link TableEditor} is able to handle saving of the data himself
    * @uses TableEditor
    * @return string html-content
    * @global array country acronyms and names
    * @global DB used for database access
    */
    function createOptionsForm() {
    
        global $country,$db;
        
        $cont = '<fieldset class="options-options">';
        $cont .= '<legend>Change your options</legend>';
        
        $tEdit = new TableEditor($db,TABLE_USERS,'userid',
            array(
                'id' => 'hidden',
                'usertype' => 'hidden',
                'password' => 'hidden',
                'reg_email' => 'hidden',
                'confirm_hash' => 'hidden',
                'lastLogin' => 'hidden',
                'limitEntries' => 'text-5',
                'bdayDisplay' => array (
                    'NULL' => 'default',
                    '0' => 'no',
                    '1' => 'yes'
                ),
                'bdayInterval' => 'text-3',
                'language' => array(
                    'NULL' => 'autodetect',
                    'english' => 'english'
                ),
                'useMailScript' => 'hidden' // not supported in 3.0 (see mailto.php) == Users can select this even if admin says no!
                /*'useMailScript' => array(
                    'NULL' => 'default',
                    '0' => 'no',
                    '1' => 'yes'
                )*/
            ),
            array(
                'limitEntries' => 'Main list: limit entries per page',
                'bdayInterval' => 'Main list: display dates and recently changed contacts n days back',
                'bdayDisplay' => 'Main list: display dates',
                'language' => 'User interface language (only English in 3.0)',
                'useMailScript' => 'Users can send email with a web interface from the server (not supported in 3.0)'
            ),
            'SELECT * FROM ' . TABLE_USERS . ' WHERE userid = ' . ($this->user!==null?$db->escape($this->user->id):$_SESSION['user']->id),
            'text',
            true,
            ($this->user!==null?'userid=' . $this->user->id:'')
        );
        
        $cont .= $tEdit->create('','');
        
        $cont .= '</fieldset>';
        
        return $cont;
    
    }
    
}
    
?>
