<?php
/**
* contains class {@link PageRecentlyChanged}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/backEnd/ChangedContactList.class.php');
require_once('lib/backEnd/User.class.php');
require_once('lib/frontEnd/Page.class.php');
require_once('lib/utilities/TableGenerator.class.php');

/**
* the recently changed entries page
* 
* this page is mainly used from inside {@link PageList}
* it displays the contacts were recently changed
* it is also possible to used it standalone (just call {@link create()}
* instead of {@link innerCreate()}
* @package frontEnd
* @subpackage pages
* @uses DateContactList
*/
class PageRecentlyChanged extends Page {
    
    /**
    * @var ChangedContactList list of contacts which were recently changed
    */
    var $contactList;
    
    /**
    * @var limit of entries
    */
    var $limit;
    
    /**
    * Constructor
    * 
    * init superclass, init {@link $contactList}
    * @global Options determine how many days after change the contact should still be shown
    */
    function PageRecentlyChanged($limit=0) {
        
        global $options;
        
        $this->Page('Recently changed (past ' . $options->getOption('bdayInterval') . ' days)');
        
        $this->contactList = new ChangedContactList($options->getOption('bdayInterval'),$limit);
        
        $this->contactList->setShowDeleted(true);
        $this->contactList->setShowImported(false);
        
    }
    
    /**
    * create the content of recently changed
    * @return string html-content
    * @global Options determine how many days after change the contact should still be shown
    * @param boolean $compact whether list should be displayed with imported link and user who changed contact
    */
    function innerCreate($compact = false) {
        
        global $options;
        
        $contacts = $this->contactList->getContacts();
        
        $data = array();
        
        foreach($contacts as $c) {
                
            $who = new User(intval($c->contact['whoModified']));
            
            if($c->contact['lastModification']!='deleted' || $_SESSION['user']->isAtLeast('admin'))
                $contactLink = '<a href="contact.php?id=' . $c->contact['id'] . '">' . $c->contact['lastname'] . (!empty($c->contact['firstname']) ? ', ' . $c->contact['firstname'] : '') . '</a>';
            else
                $contactLink = $c->contact['lastname'] . (!empty($c->contact['firstname']) ? ', ' . $c->contact['firstname'] : '');
                
            $data[] = array(
                'display_name' => $contactLink,
                'chdate' => date('F j',strtotime($c->contact['lastUpdate'])),
                'change' => $c->contact['lastModification'],
                'reset' => '<a href="saveadmin.php?id=' . $c->contact['id'] . '&amp;mode=imported">imported</a>',
                'who' => isset($who->contact['id']) ? '<a href="contact.php?id=' . $who->contact['id'] . '">' . $who->contact['lastname'] . (!empty($who->contact['firstname']) ? ', ' . $who->contact['firstname'] : '') . '</a>' : 'null'
            );
            
        }
        
        $tGen = new TableGenerator('changed-list');
        
        $cont = '<table class="changed-list">';
        
        $cont .= '<caption>Recently changed (past ' . $options->getOption('bdayInterval') . ' days)';
        
        if ($compact)
            $cont .= '&nbsp;<a href="changedlist.php">expand</a>';
 
        $cont .= '</caption>';
        
        if (count($data) > 0)
            if ($_SESSION['user']->isAtLeast('admin') && !$compact)
                $cont .= $tGen->generateBody($data,array('display_name','chdate','change','reset','who'));
            else
                $cont .= $tGen->generateBody($data,array('display_name','chdate','change'));
        else
            $cont .= '<tr class="noentry"><td>Nothing changed</td></tr>';
        
        $cont .= '</table>';
        
        if (!$compact)
            $cont .= '<div><a href="list.php">return</a></div><br>';
        
        return $cont;
        
    }

}

?>
