<?php
/**
* contains class {@link PageRegister}
* @author Tobias Schlatter
* @package frontEnd
* @subpackage pages
*/

/** */
require_once('lib/frontEnd/Page.class.php');
require_once('lib/backEnd/Contact.class.php');
require_once('lib/backEnd/User.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');

/**
* the register page
* 
* this page generates several small pages,
* all used for registering or lost passwords
* if an admin wants to create a user, this class is
* also used
* @package frontEnd
* @subpackage pages
*/
class PageRegister extends Page {

    /**
    * @var string which mode are we in (lostpasswd,confirm,resend,register,cuser)
    */
    var $mode;
    
    /**
    * @var string submode of page (e.g. error,ok)
    */
    var $flag;
    
    /**
    * Constructor
    *
    * saves passed vars and inits superclass with right title according to {@link $mode}
    * @param string $mode mode of page
    * @param string $flag submode of page
    */
    function PageRegister($mode,$flag) {
    
        $this->mode = $mode;
        $this->flag = $flag;
        
        switch ($this->mode) {
            case 'lostpasswd':
                $this->Page('Lost password');
            break;
            case 'confirm':
                $this->Page('Confirm E-Mail');
            break;
            case 'resend':
                $this->Page('Resend confirmation E-Mail');
            break;
            case 'register':
                $this->Page('Register Account');
            break;
            case 'cuser':
                $this->Page('Create new user');
            break;
        }
    
    }

    /**
    * create the content of register page
    *
    * just calls the function for current mode and returns return value of func.
    * @return string html-content
    * @uses createLostPassword()
    * @uses createConfirm()
    * @uses createRegister()
    * @uses createCreateUser()
    * @uses createResend()
    */
    function innerCreate() {
    
        switch ($this->mode) {
            case 'lostpasswd':
                return $this->createLostPassword();
            case 'confirm':
                return $this->createConfirm();
            case 'register':
                return $this->createRegister();
            case 'cuser':
                return $this->createCreateUser();
            case 'resend':
                return $this->createResend();
        }
    
    }
    
    /**
    * create message, that confirmation e-mail has been resent
    * @global ErrorHandler used to catch errors that occured
    * @return string html-content
    */
    function createResend() {
        
        global $errorHandler;
        
        $cont = '<div class="login-form">';
        
        $cont .= '<img class="tab-title" src="images/banner.png" />';
        
        switch ($this->flag) {
        
            case 'error':
                ($err = $errorHandler->getLastError('register'))
                || ($err = $errorHandler->getLastError('login'));
                
                $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
                
            break;
            
            case 'ok':
                
                $cont .= '<div class="login-message">Your confirmation e-mail has been resent</div>';
                
            break;
            
        }
        
        $cont .= '</div>';
        
        return $cont;
        
    }
    
    /**
    * create form to create a new user (only used by admin)
    * @global ErrorHandler used to catch errors that occured
    * @return string html-content
    */
    function createCreateUser() {
        
        global $errorHandler;
        
        $cont = '<div class="login-form">';
        
        $cont .= '<img class="tab-title" src="images/banner.png" />';
        
        switch ($this->flag) {
            
            case 'ok':
                $cont .= '<div class="login-message">Successfully added user</div>';
            break;
            
            case 'error':
                ($err = $errorHandler->getLastError('register'))
                || ($err = $errorHandler->getLastError('login'));
                
                $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
                
            break;
            
            default:
        
                if (!isset($_GET['id']))
                    $_GET['id'] = '';
                    
                $contact = new Contact(intval($_GET['id']));
                
                $mails = $contact->getValueGroup('email');
                
                if ($contact->isUser()) {
                    $cont .= '<div class="login-error">This contact is already a user</div>';
                    break;
                }
                
                if (count($mails) <= 0) {
                    $cont .= '<div class="login-error">This contact has no e-mail-address</div>';
                    break;
                }

                
                $cont .= '<div class="login-message">Please choose e-mail-address to use and enter password</div>';
                $cont .= '<form action="register.php?mode=cuser&amp;id=' . $contact->contact['id'] . '" method="post">';
                $cont .= '<div><label for="email">e-mail</label></div>';
                
                $cont .= '<div><select name="email" id="email">';
                
                foreach ($mails as $m)
                    $cont .= '<option>' . $m['value'] . '</option>';
                
                $cont .= '</select></div>';
                        
                $cont .= '<div><label for="password1">password</label></div>';
                $cont .= '<div><input type="password" name="password1" id="password1" /></div>';
                $cont .= '<div><label for="password1">repeat</label></div>';
                $cont .= '<div><input type="password" name="password2" id="password2" /></div>';
                $cont .= '<div><input type="submit" value="ok" /></div>';
                $cont .= '</form>';
        }
        
        $cont .= '<div><a href="contact.php?id=' . $_GET['id'] . '">return</a></div>';
        $cont .= '</div>';
        
        return $cont;
        
    }
    
    /**
    * create form to register (only used by new users)
    * @global ErrorHandler used to catch errors that occured
    * @return string html-content
    */
    function createRegister() {
    
        global $errorHandler;
        
        $cont = '<div class="login-form">';
                
        $cont .= '<img class="tab-title" src="images/banner.png" />';
        
        switch ($this->flag) {
            case 'error':
                ($err = $errorHandler->getLastError('register'))
                || ($err = $errorHandler->getLastError('login'));
                
                $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
                
            break;
            case 'ok':
                
                $cont .= '<div class="login-message">An e-mail has been send to you. Please use the link to confirm your account.</div>';
                
            break;
            default:
                
                $cont .= '<div class="login-message">Please enter your e-mail and select a password</div>';
                $cont .= '<form action="register.php?mode=register" method="post">';
                $cont .= '<div><label for="email">e-mail</label></div>';
                $cont .= '<div><input type="text" name="email" id="email" /></div>';
                $cont .= '<div><label for="password1">password</label></div>';
                $cont .= '<div><input type="password" name="password1" id="password1" /></div>';
                $cont .= '<div><label for="password1">repeat</label></div>';
                $cont .= '<div><input type="password" name="password2" id="password2" /></div>';
                $cont .= '<div><input type="submit" value="ok" /></div>';
                $cont .= '</form>';
                
            break;
        }
        
        $cont .= '</div>';
            
        return $cont;
    
    }
    
    /**
    * create page to show user, that his contact has been confirmed
    * also show link to contact page
    * @global ErrorHandler used to catch errors that occured
    * @return string html-content
    */
    function createConfirm() {
        
        global $errorHandler;
        
        $cont = '<div class="login-form">';
                
        $cont .= '<img class="tab-title" src="images/banner.png" />';
        
        switch ($this->flag) {
            case 'found':
                $cont .= '<div>Your contact-entry has already been found in the address book.</div>';
                $cont .= '<div>Please check, if all data is correct: <a href="contact.php?id=' . $_SESSION['user']->contact['id'] . '">open my address-card</a></div>';
            break;
            case 'created':
                $cont .= '<div>A contact-entry has been created for you.</div>';
                $cont .= '<div>Please enter, all contact data: <a href="contact.php?id=' . $_SESSION['user']->contact['id'] . '&amp;mode=edit">open my address-card</a></div>';
            break;
            case 'error':
                ($err = $errorHandler->getLastError('register'))
                || ($err = $errorHandler->getLastError('login'));
                
                $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
                
            break;
            case 'ok':
                
                $cont .= '<div>Your e-mail has been successfully confirmed.</div>';
                $cont .= '<div>You can <a href="list.php">use</a> the address book now.</div>';
                
            break;
            default:
                
                $cont .= '<div class="login-message">Please log in to confirm your account</div>';
                $cont .= '<form action="register.php?mode=confirm" method="post">';
                $cont .= '<input type="hidden" name="userid" value="' . $_GET['userid'] . '" />';
                $cont .= '<input type="hidden" name="hash" value="' . $_GET['hash'] . '" />';
                $cont .= '<div><label for="email">e-mail</label></div>';
                $cont .= '<div><input type="text" name="email" id="email" /></div>';
                $cont .= '<div><label for="password">password</label></div>';
                $cont .= '<div><input type="password" name="password" id="password" /></div>';
                $cont .= '<div><input type="submit" value="confirm" /></div>';
                $cont .= '</form>';
                
                
            break;
        }
        
        $cont .= '</div>';
            
        return $cont;
        
    }
    
    /**
    * create form/page to restore password of a user
    * @global ErrorHandler used to catch errors that occured
    * @return string html-content
    */
    function createLostPassword() {
        
        global $errorHandler;
        
        $cont = '<div class="login-form">';
                
        $cont .= '<img class="tab-title" src="images/banner.png" />';
        
        switch ($this->flag) {
            case 'error':
                ($err = $errorHandler->getLastError('register'))
                || ($err = $errorHandler->getLastError('mail'));
                
                $cont .= '<div class="login-error">' . $err['cause'] . '</div>';
                
            break;
            case 'changed':
                $cont .= '<div>An e-mail with your new password has been sent to you</div>';
                $cont .= '<div>Go to the <a href="index.php">login page</a> to use it</div>';
            break;
            default:
                
                $cont .= '<form action="register.php?mode=lostpasswd" method="post">';
                $cont .= '<div class="login-message"><label for="email">Please enter your e-mail address, and we will send you a new password</label></div>'; 
                $cont .= '<div><input type="text" name="email" id="email" /></div>';
                $cont .= '<div><input type="submit" value="reset password" /></div>';
                $cont .= '</form>';
                
            break;
        }
        
        $cont .= '</div>';
        
        return $cont;
        
    }

}
