<?php
/**
* contains class {@link AddressFormatter}
* @package utilities
* @author Tobias Schlatter, Thomas Katzlberger
*/

/**
* Class to format addresses correct for printing according to a country's customs.
* @link http://www.bitboost.com/ref/international-address-formats.html
* @package utilities
*/
class AddressFormatter
{
        /**
        * @var array format of addresses by country acronym
        */
        var $addressOutputFormat =
        array (
                '0'  => array('line1', '%', 'line2', '%', 'city', 'state', 'zip', '%', 'country'),
                'ar' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'au' => array('line1', '%', 'line2', '%', 'city', 'state', 'zip', '%', 'country'),
                'at' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'be' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),

                /* I'm not sure about Brasil */
                'br' => array('line1', '%', 'line2', '%', 'city', ' - ', 'state', '%', 'country'),

                'ca' => array('line1', '%', 'line2', '%', 'city', 'state', 'zip', '%', 'country'),

                /* What's the M in Odense M?? */
                'dk' => array('line1', '%', 'line2', '%', 'zip', 'city', /* 'state' ?? ,*/ '%', 'country'),

                'fi' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'fr' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'de' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'gb' => array('line1', '%', 'line2', '%', 'city', '%', 'state', '%', 'zip', '%', 'country'),
                'hk' => array('line1', '%', 'line2', '%', 'city', '%', 'country'),
                'is' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'in' => array('line1', '%', 'line2', '%', 'city', '-', 'zip', '%', 'country'),
                'id' => array('line1', '%', 'line2', '%', 'city', 'zip', '%', 'country'),
                'ie' => array('line1', '%', 'line2', '%', 'city', 'zip', 'state', '%', 'country'),
                'il' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'it' => array('line1', '%', 'line2', '%', 'zip', '-', 'city', 'state', '%', 'country'),
                'jp' => array('line1', '%', 'line2', '%', 'city', 'zip', '%', 'country'),
                'lu' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'mx' => array('line1', '%', 'line2', '%', 'zip', 'city', ', ', 'state', '%', 'country'),
                'nl' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'nz' => array('line1', '%', 'line2', '%', 'city', 'zip', '%', 'country'),
                'no' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'cn' => array('line1', '%', 'line2', '%', 'city', 'zip', '%', 'country'),
                'pl' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'pt' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'ru' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'sg' => array('line1', '%', 'line2', '%', 'country', 'zip', '%', 'country'),
                'za' => array('line1', '%', 'line2', '%', 'city', '%', 'zip', 'country'),
                'kr' => array('line1', '%', 'line2', '%', 'city', 'zip', '%', 'country'),
                'es' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'se' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'ch' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),
                'hu' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'),

                /* Where comes state/county/or whatever?? */
                'tw' => array('line1', '%', 'line2', '%', 'city', ', ', 'zip', '%', 'country'),
                'cn' => array('line1', '%', 'line2', '%', 'zip', 'city', '%', 'country'), // China is confused ...
                //'cn' => array('line1', '%', 'line2', '%', 'zip', 'city', ', ', 'state', '%', 'country'),

                'us' => array('line1', '%', 'line2', '%', 'city', ', ', 'state', 'zip', '%', 'country'),
                'um' => array('line1', '%', 'line2', '%', 'city', 'state', 'zip', '%', 'country')
        );
       
       /**
       * format an address using a custom delimeter
       *
       * if no delimeter is specified, html output is generated
       * @param array $addData associative array with address data
       * @param string $delimeter delimeter used to separate data which is on the same line, html output if not specified
       * @return string html or plaintext output
       */
       function formatAddress($addData,$delimeter='')
       {
            global $country;        
                            
            if ($addData['country'] && isset($this->addressOutputFormat[$addData['country']])) {
                    $format = $this->addressOutputFormat[$addData['country']];
            }
            else
                $format = null;

            if(!$format) // double check if the country code was not defined in $addressOutputFormat
                    $format = $this->addressOutputFormat['0'];
            
            $html = !$delimeter;
            
            $tmp = '';
            $del = $delimeter;

            foreach ( $format as $v ) {

                    $data = '';


                    switch ($v) {
                        case 'line1':
                            $data = $addData['line1'];
                        break;
                        case 'line2':
                            $data = $addData['line2'];
                        break;
                        case 'city':
                            if ($html && $addData['city'])
                                $data = '<span class="address-city">'.$addData['city'].'</span>';
                            else
                                $data = $addData['city'];
                        break;
                        case 'state':
                            if($html && $addData['state'])
                                $data = '<span class="address-state">'.$addData['state'].'</span>';
                            else
                                $data = $addData['state'];
                        break;
                        case 'zip':
                            if($html && $addData['zip'])
                                $data = '<span class="address-zip">'.$addData['zip'].'</span>';
                            else
                                $data = $addData['zip'];
                        break;
                        case 'country':
                            if ($addData['country'] && $addData['country'] != '0') {
                                if ($html)
                                    $data = '<span class="address-country">'.$country[$addData['country']].'</span>';
                                else
                                    $data = $country[$addData['country']];
                            }
                        break;
                        case '%': // substitute arbitrary delimiter
                            if ($html)
                                $del = '%';
                            else
                                $del = $delimeter;
                        break;
                        default:
                            $del = $v;
                        break;
                    }

                    if ($data == '')
                            continue;

                    if ($tmp == '') {
                        if ($html)
                            $tmp = '<div class="address-line">' . $data;
                        else
                            $tmp = $data;
                        continue;
                    }

                    if ($html && $del == '%')
                        $tmp .= '</div><div class="address-line">';
                    else
                        $tmp .= $del;
                    
                    $del = ' ';
                    $tmp .= $data;

            }
            
            if ($html && $tmp)
                $tmp .= '</div>';
            
            return $tmp;
       }

}

global $addressFormatter;
/**
* @global AddressFormatter $addressFormatter
*/
$addressFormatter = new AddressFormatter();

?>
