<?php
/**
* contains class {@link EmailHelper}
* @package utilities
* @author Thomas Katzlberger
*/

/**
* utility class to generate mailto: links OR return a link to an internal mail script
* Any link for sending an emails should pass through this class to create a central 
* hook if someone wants to change sending emails through a serverside interface.
* @package utilities
*/
class EmailHelper {

    /**
    * STATIC method that generates a HTML link to send an email
    *
    * @param string $text text between <a> and </a>
    * @param string|array list of emails
    * @return string <a href="mailto:-emails-"> $text </a>
    */
    function sendEmailLink($email, $text) 
    {
        $ret = "<a href='mailto:";
        
        if(!is_array($email))
            return $ret . EmailHelper::obscureString($email) . "'>" . EmailHelper::obscureString($text) . '</a>';
        
        foreach($email as $e)
            $ret .= EmailHelper::obscureString($e) . ",";       
        
        return $ret . "'>" . EmailHelper::obscureString($text) . '</a>';
    }
    
    /**
    * replaces every character with the html equivalent of the form &#....;
    * 
    * used to obscure e-mail addresses, which prevents auto reading (of course it would be possible,
    * but most web-spiders can't handle them
    * @param string $str string to obscure
    * @return string obscured string
    */
    function obscureString($str) {
        return mb_encode_numericentity($str,array(
            0x00,0xffff,0,0xffff
        ));
    }   
}

?>
