<?php
/**
* contains class {@link RightsManager}
* @package utilities
* @author Tobias Schlatter
*/

/** */
require_once('lib/backEnd/User.class.php');
require_once('lib/backEnd/Contact.class.php');

/**
* class to manage the rights of a user of TAB
* @package utilities
*/
class RightsManager {
  
    /**
    * check whether a user may view a contact
    * @param User $user user that wants to view the contact
    * @param Contact $contact contact that should be showed
    * @static
    */
    function mayViewContact(&$user,&$contact) {
        return !$contact->contact['hidden'] || $user->isAtLeast('admin');
    }
    
    /**
    * check whether a user may edit a contact
    * @param User $user user that wants to edit the contact
    * @param Contact $contact contact that should be edited
    * @static
    */
    function mayEditContact(&$user,&$contact) {
        return
            ($user->isAtLeast('manager') ||
            $user->id == $contact->isUser() ||
            $user->id == $contact->contact['whoAdded']) &&
            $user->isAtLeast('user') &&
            RightsManager::mayViewContact($user,$contact);
    }
    
    /**
    * check whether a user may delete a contact
    * @param User $user user that wants to delete the contact
    * @param Contact $contact contact that should be deleted
    * @static
    */
    function mayDeleteContact(&$user,&$contact) {
        return RightsManager::mayEditContact($user,$contact);
    }
    
    /**
    * check whether a user may view private info of a contact
    * @param User $user user that wants to view the private info
    * @param Contact $contact contact of which the private info should be showed
    * @static
    */
    function mayViewPrivateInfo(&$user,&$contact) {
        return
            $user->isAtLeast('admin') ||
            $user->contact['id'] == $contact->contact['id'] &&
            !$contact->contact['hidden'];
    }
    
}

?>
