<?php
/*************************************************************
 *  THE ADDRESS BOOK
 *   
 *************************************************************
 *
 *  list.php
 *  Lists address book entries. This is the main page.
 *
 *************************************************************/

    require_once('init.php');
    require_once('lib/frontEnd/pages/PageList.class.php');
    require_once('lib/utilities/StringHelper.class.php');
    require_once('lib/utilities/HTMLBeautifier.class.php');
    require_once('lib/backEnd/ErrorHandler.class.php');

    if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
        require('index.php');
        

    
    if (!isset($_GET['group']) || $_GET['group'] == 'hidden' && !$_SESSION['user']->isAtLeast('admin'))
        $_GET['group'] = '';
    
    if (!isset($_GET['begin']))
        $_GET['begin'] = '';
    
    if (!isset($_GET['page']))
        $_GET['page'] = 0;
    
    if (!isset($_GET['expand']))
        $_GET['expand'] = 0;
    
    $page = new PageList(
        StringHelper::cleanGPC($_GET['group']),
        $_GET['expand'],
        StringHelper::cleanGPC($_GET['begin']),
        intval(StringHelper::cleanGPC($_GET['page']))
    );
    //echo HTMLBeautifier::beautify($page->create());
    echo $page->create();

    exit();
    
?>
