<?php

// If a whitespace is outputted during header files
ob_start();

require_once('init.php');

require_once('lib/backEnd/Contact.class.php');
require_once('lib/utilities/RightsManager.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');

// kill whitespaces
ob_end_clean();

if (!isset($_GET['id']))
    $_GET['id'] = '';
    
    
$contact = new Contact(intval($_GET['id']));

if (!RightsManager::mayViewContact($_SESSION['user'],$contact))
    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));


header('Content-Type: image/jpeg');
header('Content-Length: ' . strlen($contact->contact['pictureData']));

echo $contact->contact['pictureData'];

exit();

?>
