<?php

require_once('init.php');
require_once('lib/frontEnd/pages/PageOptions.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');
require_once('lib/utilities/StringHelper.class.php');
require_once('lib/backEnd/User.class.php');

if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
    $errorHandler->standardError('NOT_LOGGED_IN',basename($_SERVER['SCRIPT_NAME']));
    
if (!$_SESSION['user']->isAtLeast('user'))
    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));

if (isset($_GET['userid']))
    if ($_SESSION['user']->isAtLeast('admin')) {
        $eUser = new User(intval($_GET['userid']));
        $page = new PageOptions($eUser);
    } else {
        $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));
    }
else {
    $eUser = $_SESSION['user'];
    $page = new PageOptions();
}

if (isset($_GET['mode']))
    switch ($_GET['mode']) {
        case 'password':
            if (!isset($_POST['oldPassword'],$_POST['newPassword1'],$_POST['newPassword2']) || $_POST['newPassword1'] != $_POST['newPassword2']) {
                $errorHandler->error('formVal','New passwords do not match.',basename($_SERVER['SCRIPT_NAME']));
                break;
            }
            
            if (($_SESSION['user']->isAtLeast('admin') && $eUser->id != $_SESSION['user']->id) || $user->login($_POST['oldPassword'])) {
                $eUser->setPassword(StringHelper::cleanGPC($_POST['newPassword1']));
                $errorHandler->error('ok',"Password successfully changed.");
            } else
                $errorHandler->error('formVal','Incorrect old password.',basename($_SERVER['SCRIPT_NAME']));
                
        break;
        case 'email':
            if (isset($_POST['email'])) {
                $eUser->setEmail(StringHelper::cleanGPC($_POST['email']));
                if (($err = $errorHandler->getLastError('register')) || ($err = $errorHandler->getLastError('mail'))) {
                    $errorHandler->error('formVal',$err['cause'],basename($_SERVER['SCRIPT_NAME']));
                    break;
                }
                if ($eUser->id == $_SESSION['user']->id) {
                    $_SESSION['user'] = null;
                    require('index.php');
                }
            }
        break;
    }
    
echo $page->create();
    
?>
