<?php
/*************************************************************
 *  SSL Certificate Authority PLUGIN for THE ADDRESS BOOK
 *************************************************************/

require_once('lib/backEnd/ErrorHandler.class.php');
global $errorHandler;

if (!@include_once('plugins/AdminCertificateAuthority/config.php'))
    require_once('plugins/AdminCertificateAuthority/config.template.php');
    
require_once('lib/backEnd/DB.class.php');
require_once('lib/frontEnd/Navigation.class.php');
require_once('lib/utilities/StringHelper.class.php');
require_once('lib/utilities/RightsManager.class.php');

class AdminCertificateAuthority {
	
	// CONSTRUCTOR FUNCTION - not needed

	function isType($t) { return $t=='listMenu' || $t=='contactOutput' || $t=='editContactInterface' || $t=='changedContactRecord'; }
	
	/* There is not much to do here except to generate a link that will perform the actual work
	 *
	 *Useful globals:
	 *		$_SESSION['user']  instance of User for current user
	 */
	function makeMenuLink(&$contact,&$nav)
	{
		if($_SESSION['user']->isAtLeast('admin'))
            $nav->addEntry('plugin.AdminCertificateAuthority','SSL-CA','plugins/AdminCertificateAuthority/gencerts.php');
		
	}

	/* There is not much to do here except to generate a link that will perform the actual work
	 *
	 *Useful globals:
	 *		$_SESSION['usertype'] (admin,manager,user)
	 *		$_SESSION['username']
     *      $_GET, $_POST
     *      $contact the class Contact used in address.php
	 */
	function contactOutput(&$contact, $location)
	{
        
        if($location != 'beforeNotes')
            return '';
        
        $cont = '';
        
        if(RightsManager::mayViewPrivateInfo($_SESSION['user'],$contact))
        {
            $cont .= '<div class="other-spacer"></div>';
    
            $cont .= '<div class="other"><span class="other-label">Organizational Unit</span><span class="other-info">';
            
            if (empty($contact->contact['organizationalUnit']))
                $cont .= "- blank -";
            else
                $cont .= $contact->contact['organizationalUnit'];
            
            $cont .= '</span></div>';
    
            $cont .= '<div class="other"><span class="other-label">Certificate State</span><span class="other-info">';
            
            if($_SESSION['user']->isAtLeast('admin'))
            {
                $s = $contact->contact['certState'];
                if($s=='used')
                    $lastUsed = '('.$contact->contact['certLastUsed'].')';
                else
                    $lastUsed='';
                
                $cont .= '<a href="#" onclick="effect_1 = Effect.SlideDown(\'certChanger\',{duration:1.2}); return false;">' . $s . '</a> '.$lastUsed;
            }
            else
            {
                $s = $contact->contact['certState'];
                $cont .= $s;
            }
            
            $cont .= '</span></div>';
    
            // Hidden changer div for scriptacuous magic:

            $id = $contact->contact['id'];
            $cont .= '<div class="other" id="certChanger" style="display:none;"><span class="other-info">Change: 
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=new">new</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=revoke">revoke</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=none">(none)</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=issued">(issued)</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=mailed">(mailed)</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=used">(used)</a>
                <a href="saveadmin.php?mode=cycleCertState&amp;id=' . $id . '&amp;newState=revoked">(revoked)</a></span></div>';
            
            if($s != 'none')
            {
                $cont .= '<div class="other"><span class="other-label">Certificate Expires</span><span class="other-info">';
                $cont .= (empty($contact->contact['certExpires']) ? '- not set -' : $contact->contact['certExpires']) . '</span></div>';
                
                $x = $contact->contact['certPassword'];

                if(!empty($x))
                    $cont .= '<div class="other"><span class="other-label">Certificate Password</span><span class="other-info" style="font-family: Courier">' . htmlentities($x) . ' (0=zero, O=oscar, 1=one, l=lima)</span></div>';
            }
        }
        
        return $cont;
        
	}    

    // Insert Organizational Unit Interface after otherInfo
    function editContactInterface(&$contact, $location)
    {
		global $CONFIG_CA_OU_CHOICES,$CONF_CERT_REQUEST_TEXT;

		if($location!='otherInfo') 
            return "";
        
        if(!isset($contact->contact['organizationalUnit'])) // add new entry menu ... prepare default
            $contact->contact['organizationalUnit'] = $CONFIG_CA_OU_CHOICES[0];
                        
        if (in_array($contact->contact['organizationalUnit'],$CONFIG_CA_OU_CHOICES))
            $cont = PageContactEdit::createDropdown('contact[organizationalUnit]','Organizational Unit',$CONFIG_CA_OU_CHOICES,$contact->contact['organizationalUnit'],true);
        else
            $cont = PageContactEdit::createDropdown('contact[organizationalUnit]','Organizational Unit',
                array_merge($CONFIG_CA_OU_CHOICES,array($contact->contact['organizationalUnit'])),
                $contact->contact['organizationalUnit'],true);
        
        // if manager display choice to request certificate
        if ($_SESSION['user']->isAtLeast('manager'))
            $cont .= PageContactEdit::createCheckbox('new_cert_request',empty($CONF_CERT_REQUEST_TEXT) ? "Request new certificate" : $CONF_CERT_REQUEST_TEXT);
        
        return $cont;
    }

    function changedContactRecord(&$contact,$mode) {
        
        global $CONFIG_CA_OU_CHOICES, $db, $CONF_CERT_REQUEST_TEXT, $errorHandler;
        
        if ($mode != 'will_change' && $mode != 'will_add')
            return;
        
        // Certificate request
        if ($_SESSION['user']->isAtLeast('manager') && $_POST['new_cert_request'])
        {
            if($contact->contact['certState'] == 'none')
            {
                $contact->contact['certState'] = 'new';
                $errorHandler->error('ok','SSL_CA: ' . (empty($CONF_CERT_REQUEST_TEXT) ? "Request new certificate" : $CONF_CERT_REQUEST_TEXT) . ' processed.' );
            }
            else
                $errorHandler->error('warning','SSL_CA: ' . (empty($CONF_CERT_REQUEST_TEXT) ? "Request new certificate" : $CONF_CERT_REQUEST_TEXT) . ' failed: User has already a (valid/expired/revoked) certificate' );
        }
            
        // Check, if value of organizational unit is allowed
        
        // Admin may do anything
        if ($_SESSION['user']->isAtLeast('admin'))
            return;
        
        // Is a predefined value
        if (in_array($contact->contact['organizationalUnit'],$CONFIG_CA_OU_CHOICES))
            return;
        
        // Value was incorrect, or a custom one
        
        // no custom, because new contact, set default
        if ($mode == 'will_add') {
            $contact->contact['organizationalUnit'] = $CONFIG_CA_OU_CHOICES[0];
            return;
        }
        
        // Retrieve old value (to reset, or because it is the custom one)
        // the query here is somewhat sloppy, because actually the contact class
        // should do that... but there is no rollback implemented (yet)
        $db->query('SELECT * FROM ' . TABLE_CONTACT . ' WHERE id = '. $db->escape($contact->contact['id']),'ca');
        $r = $db->next('ca');
        $contact->contact['organizationalUnit'] = $r['organizationalUnit'];
        
    }
    
    function installPlugin()
    {
		global $db,$CONF_CERT_DAYS_TILL_EXPIRE;

		// Certificate Authority DB extensions
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD certLastUsed DATE DEFAULT NULL"); 
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD organizationalUnit VARCHAR(25) DEFAULT NULL");
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD certPassword VARCHAR(30) DEFAULT NULL");
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD certExpires DATE DEFAULT NULL"); 
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD certState ENUM( 'none', 'new', 'revoke', 'issued', 'mailed', 'used', 'expired' ,'revoked' ) NOT NULL DEFAULT 'none'");
            // none = has no cert; new = will issue next time; revoke = revoke next time; issued = have generated issuing request        
        $db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " ADD certModifiedAt DATE NULL DEFAULT NULL");
        $db->query('UPDATE ' . TABLE_CONTACT . ' SET certModifiedAt = SUBDATE(certExpires,' . $db->escape($CONF_CERT_DAYS_TILL_EXPIRE) . ') WHERE ( certState="issued" OR certState="used" ) AND certModifiedAt IS NULL');
    }
    
    function uninstallPlugin()
    {
		global $db;

		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP certState");
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP certExpires"); 
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP certPassword");
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP organizationalUnit");
		$db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP certLastUsed");
        $db->queryNoError("ALTER TABLE " . TABLE_CONTACT . " DROP certModifiedAt"); 
    }
    
    // Upgrades the plugin; called from adminPanel.php
    function upgradePlugin($oldVersion)
    {
		global $db;

        switch($oldVersion)
        {
            case null: // no version ... added 'revoke' to mark a cert to be revoked next time SSL-CA runs
                $db->query("ALTER TABLE " . TABLE_CONTACT . " CHANGE certState certState ENUM( 'none', 'new', 'revoke', 'issued', 'mailed', 'used', 'expired' ,'revoked' ) NOT NULL DEFAULT 'none';");
        }
        
        $db->query('UPDATE ' . TABLE_PLUGINS . ' SET version = "' . $this->version() . '"
                WHERE name = "AdminCertificateAuthority"');
    }
    
    function version() {
        return '0.8';
    }
}
?>