<?php
	/**
	GoogleMapping and geocoding interface:
	
		function canGeocode($countryCode) returns true/false
		function geocode($tbl_address) returns array('latitude','longitute');
		function canMap($countryCode) returns true/false
		function showMapAt($latitude,$longitude) exits
		function showMap($tbl_address) returns false or exits
	*/

    require_once('lib/utilities/AddressFormatter.class.php');
    
	class GoogleMaps
	{
		// Is there a geocoder to translate addresses?
		// This means that at least showMap($tbl_address) will work
		// However geocode() may still return null if translation to lat/long is not possible
		function canGeocode($countryCode)
		{
			// Included countries see: http://www.google.com/apis/maps/faq.html#faq14
			// GEOCODER: Canada, France, Germany, Italy, Spain, and United States of America
			$valid_countries = array( 'ca'=>1, 'fr'=>1, 'de'=>1, 'it'=>1, 'es'=>1, 'us'=>1 );

			if(array_key_exists($countryCode, $valid_countries))
				return true;
			
			return false;
		}

		// returns null on failure or array('latitude'=>$la,'longitute'=>$lo);
		function geocode($tbl_address,&$errorMessage)
		{
			$errorMessage='GoogleMaps geocoding not available.';
			return null;
		}
		
		// Are we able to display map data in this country?
		function canMap($countryCode)
		{
			// Included countries see: http://www.google.com/apis/maps/faq.html#faq14
			// Available MAPS
			// Andorra, Australia, Austria, Belgium, Canada, Czech Republic, Denmark, 
			// Finland, France, Germany, Gibraltar, Greece, Hungary, Ireland, Italy, 
			// Japan, Liechtenstein, Luxembourg, Monaco, Netherlands, New Zealand, 
			// Norway, Poland, Portugal, Russia (Moscow only), San Marino, Slovakia, 
			// Spain, Sweden, Switzerland, Turkey (Istanbul only), United Kingtom and 
			// United States of America
		    $valid_countries = array('ad'=>1,'au'=>1,'at'=>1,'be'=>1,'ca'=>1,'cz'=>1,
									 'dk'=>1,'fl'=>1,'fr'=>1,'de'=>1,'gi'=>1,
									 'gr'=>1,'hu'=>1,'ie'=>1,'it'=>1,'jp'=>1,'li'=>1,
									 'lu'=>1,'mc'=>1,'nl'=>1,'nz'=>1,'no'=>1,
									 'pl'=>1,'pt'=>1,'ru'=>0,'sm'=>1,'sk'=>1,'es'=>1,
									 'se'=>1,'ch'=>1,'tk'=>0,'uk'=>1,'us'=>1 );
			
			if(array_key_exists($countryCode, $valid_countries))
				return true;
						
			return false;
		}

		// show by latitude longitude
		function showMapAt($latitude,$longitude,$countryCode = null)
		{
			$url = "http://maps.google.com/maps?ll=" .$latitude. "," .$longitude;
			//if($countryCode) $url .= "&t=".$countryCode; // interface language
			header("Location: ".$url); //redirect to google maps!
			exit;
		}

		// this is the generic doitall
		function showMap($tbl_address)
		{
            global $addressFormatter;
            
			if(isset($tbl_address['latitude']))
			{
				// sanity check
				sscanf($tbl_address['latitude'].' '.$tbl_address['longitude'], "%f %f", $nla, $nlo);
				if(!($nla==0 && $nlo==0))	// Code for failed lookup!
					$this->showMapAt($tbl_address['latitude'],$tbl_address['longitude'],$tbl_address['country']);
			}
			
			if(!$this->canGeocode($tbl_address['country'],false))
				return false;

            $url = "http://maps.google.com/maps?daddr=" . $addressFormatter->formatAddress($tbl_address,',');
			
			//$url .= "&t=".$country; // interface language
			header("Location: ".$url); //redirect to google maps!
			exit;
		}
	}
?>
