<?php
/*************************************************************
 *  Map PLUGIN for THE ADDRESS BOOK
 *************************************************************/

    chdir('../../');
 
    require_once('init.php');
    require_once('lib/backEnd/Contact.class.php');
    require_once('lib/backEnd/DB.class.php');
    require_once('lib/utilities/StringHelper.class.php');
    require_once('lib/backEnd/ErrorHandler.class.php');

    if (isset($_GET['id']))
	    $address_id = StringHelper::cleanGPC($_GET['id']);
        
    if (isset($_GET['cid']))
	    $contact = new Contact(intval(StringHelper::cleanGPC($_GET['cid']))); // use for the google-bubble?
    
    $adds = $contact->getValueGroup('addresses');
    
    foreach ($adds as $a) {
        if ($a['refid'] == $address_id) {
            $add = &$a;
            break;
        }
    }

    if (!isset($add))
        $errorHandler->error('argVal','The address with id=' . $address_id . ' does not exist');
    
    $errorMessage = 'Unable to map this address. The address may not be included in any geocoder currently available here, or it is simply misspelled. Sorry!';
    
	// Map-o-Rama geocoder
	if(empty($add['latitude']))
	{
		require_once('plugins/Map/Map.MapoRama.php');
		$mr = new MapoRama();
		if($mr->canGeocode($add['country']))
		{

			$coords = $mr->geocode($add);

			if(is_array($coords)) // else it is an error message!
			{
				$add['latitude'] = $coords['latitude'];
				$add['longitude'] = $coords['longitude'];
				// Cache the longitude and latitude in the address record ... needs added columns in the address table!! 
				if(isset($add['latitude']) && isset($add['longitude'])) 
					$db->query('UPDATE ' . TABLE_ADDRESS . '
                    SET latitude  =' . $db->escape($add['latitude']) . ',
                        longitude =' . $db->escape($add['longitude']) . '
                    WHERE line1=' . $db->escape($add['line1']) . '
                        AND line2=' . $db->escape($add['line2']) . '
                        AND city=' . $db->escape($add['city']) . '
                        AND state=' . $db->escape($add['state']) . '
                        AND zip=' . $db->escape($add['zip']) . '
                        AND country=' . $db->escape($add['country']));
			} else // cache we have tried it once and disable the address to avoid repeated queries
            {
                $errorMessage = $coords;
				$db->query('UPDATE ' . TABLE_ADDRESS . '
                    SET latitude  = 0,
                        longitude = 0
                    WHERE line1=' . $db->escape($add['line1']) . '
                        AND line2=' . $db->escape($add['line2']) . '
                        AND city=' . $db->escape($add['city']) . '
                        AND state=' . $db->escape($add['state']) . '
                        AND zip=' . $db->escape($add['zip']) . '
                        AND country=' . $db->escape($add['country']));
            }
		}
	}
    
	// GoogleMaps
	require_once('plugins/Map/Map.GoogleMaps.php');
	$gm = new GoogleMaps();
	if($gm->showMap($add)) // returns true if successful display (will use lat/long if avail)
		exit;

	// Not successful ... use other vendor to display?
	
	$ct = $add['country'];
    $errorHandler->error('invArg',$errorMessage);

?>
