<?php
/*************************************************************
 *  THE ADDRESS BOOK
 *     
 *****************************************************************
 *  save.php
 *  Modifies address book entries (admin only).
 *
 *	There are modes. save.php?id=123&mode=... ($_GET['mode']) can be equal to:
 *	1. 'imported' 	reset lastModification
 * 
 *************************************************************/

require_once('init.php');
require_once('lib/backEnd/DB.class.php');
require_once('lib/backEnd/Contact.class.php');
require_once('lib/backEnd/User.class.php');

if (!isset($_GET['mode']))
    $_GET['mode'] = '';

if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
    $errorHandler->standardError('NOT_LOGGED_IN',basename($_SERVER['SCRIPT_NAME']));
        
if (!$_SESSION['user']->isAtLeast('admin'))
    $errorHandler->standardError('PERMISSION_DENIED',basename($_SERVER['SCRIPT_NAME']));

// -- MODES --

switch($_GET['mode'])
{
    case 'imported':
        if (isset($_GET['id']) && $_GET['id'])
            $db->query('UPDATE ' . TABLE_CONTACT . ' SET
                hidden = (lastModification != ' . $db->escape('deleted') . ' && hidden),
                lastModification = ' . $db->escape('imported') . '
                WHERE id = ' . $db->escape($_GET['id']));
        
        require('changedlist.php');
        break;

    case 'chtype':
        if (isset($_GET['userid'],$_GET['type'])) {
            $eUser = new User(intval($_GET['userid']));
            $eUser->setType($_GET['type']);
        }
        
        $_GET['id'] = $eUser->contact['id'];
        require('contact.php');
        
        break;
        
    case 'cycleCertState':
        if (isset($_GET['id'],$_GET['newState']))
            $db->query('UPDATE ' . TABLE_CONTACT . ' SET certState = ' . $db->escape($_GET['newState']) . '
            WHERE id = ' . $db->escape($_GET['id']));
        
        
        require('contact.php');
        break;
    
}
    
require('list.php');
?>
