<?php

/**
* Searches for contacts 
* Currently supported modes:
* GOTO: used by the ajax-goto in list.php
*/

require_once('init.php');
require_once('lib/backEnd/ContactList.class.php');
require_once('lib/backEnd/ErrorHandler.class.php');
require_once('lib/utilities/StringHelper.class.php');
require_once('lib/frontEnd/pages/PageSearchResult.class.php');
require_once('lib/frontEnd/pages/PageContact.class.php');

// Is a user logged in?
if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
    $errorHandler->standardError('NOT_LOGGED_IN',basename($_SERVER['SCRIPT_NAME']));

// Do we have something from the text field??
if (isset($_POST['goTo'])) {
    
    if ($_POST['goTo'] == 'whoami' && isset($_SESSION['user']->contact['id'])) {
        $_GET['id'] = $_SESSION['user']->contact['id'];
        require('contact.php');
    }
    
    // Remove single quotes which come from $db->escape
    $goTo = mb_substr($db->escape(StringHelper::cleanGPC($_POST['goTo'])),1,-1);
    
    // Search the database
    $cList = new ContactList('SELECT *
        FROM ' . TABLE_CONTACT . ' AS contact
        WHERE 
        (
            CONCAT(firstname,\' \', lastname) LIKE \'%' . $goTo . '%\' OR
            CONCAT(firstname,\' \', middlename,\' \', lastname) LIKE \'%' . $goTo . '%\' OR
            nickname LIKE \'%' . $goTo . '%\' OR
            CONCAT(lastname,\', \',firstname) LIKE \'%' . $goTo . '%\'
        )
		AND (hidden = 0 OR ' . $db->escape($_SESSION['user']->isAtLeast('admin')) . ')
        ORDER BY lastname ASC, firstname ASC');
    
    // if theres only one contact, show it
    if (count($cList->getContacts()) == 1) {
        $conts = $cList->getContacts();
        $page = new PageContact($conts[0]);
        echo $page->create();
        exit();
    }
    
    // else: show the page with a list of the contacts
    $page = new PageSearchResult($cList);
    echo $page->create();    
    
}

exit();

?>
