<?php
    require_once('init.php');
    require_once('lib/frontEnd/pages/PageSearchList.class.php');
    require_once('lib/utilities/StringHelper.class.php');
    require_once('lib/utilities/HTMLBeautifier.class.php');
    require_once('lib/backEnd/ErrorHandler.class.php');

    if (!isset($_SESSION['user']) || !$_SESSION['user']->isAtLeast('guest'))
        require('index.php');
            
    if (!isset($_GET['group']) || $_GET['group'] == 'hidden' && !$_SESSION['user']->isAtLeast('admin'))
        $_GET['group'] = '';
        
    if (!isset($_GET['search'])) $_GET['search'] = '';
    if (!isset($_GET['type'])) $_GET['type'] = '';
    if (!isset($_GET['expand'])) $_GET['expand'] = 0;
    
    // mailinglist.php?search=string&type=[name|www|chat|...]
    $page = new PageSearchList(StringHelper::cleanGPC($_GET['search']),StringHelper::cleanGPC($_GET['type']),StringHelper::cleanGPC($_GET['expand']));
    
    echo $page->create();

    exit();
?>
