<?php

/*************************************************************
 *  THE ADDRESS BOOK RELOADED 3.0
 *************************************************************/
 
require_once('config.php');
require_once('constants.inc');

require_once('lib/backEnd/DB.class.php');
require_once('lib/frontEnd/pages/PageUpgrade.class.php');

session_name('TheAddressBookSID');

// Remove old session, if there was any to avoid errors in restoring it
setcookie(session_name(), '', time()-42000, '/');

if(isset($_GET['do'])) {

    $upgrades = array();
    
    do {
        $db->query('SELECT TABversion FROM ' . TABLE_OPTIONS);
        $q = $db->next();
        if (file_exists('upgrade/' . $q['TABversion'] . '.php'))
            require('upgrade/' . $q['TABversion'] . '.php');
        else
            break;
        
    } while (true);

    $page = new PageUpgrade($upgrades,$q['TABversion']);
    
} 
else if(isset($_GET['redo'])) { 
    // hidden development option to redeploy a specific upgrade
    // This allows to upgrade the DB several times between versions, but causes errors to display
    // upgrade.php?redo=3.0.3

    $upgrades = array();

    if (file_exists('upgrade/' . $_GET['redo'] . '.php'))
        require('upgrade/' . $_GET['redo'] . '.php');        

    $page = new PageUpgrade($upgrades,$_GET['redo']);
}
else
    $page = new PageUpgrade();


echo $page->create();

?>
